/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.ovsdb.rfc.schema.type;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import java.util.Objects;
import org.onosproject.ovsdb.rfc.schema.type.BaseType;

public final class UuidBaseType
implements BaseType {
    private final String refTable;
    private final String refType;

    public UuidBaseType() {
        this.refTable = null;
        this.refType = RefType.STRONG.refType();
    }

    public UuidBaseType(String refTable, String refType) {
        Preconditions.checkNotNull((Object)refType, (Object)"refType cannot be null");
        this.refTable = refTable;
        this.refType = refType;
    }

    public String getRefTable() {
        return this.refTable;
    }

    public String getRefType() {
        return this.refType;
    }

    public int hashCode() {
        return Objects.hash(this.refTable, this.refType);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof UuidBaseType) {
            UuidBaseType other = (UuidBaseType)obj;
            return Objects.equals(this.refTable, other.refTable) && Objects.equals(this.refType, other.refType);
        }
        return false;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("refTable", (Object)this.refTable).add("refType", (Object)this.refType).toString();
    }

    public static enum RefType {
        STRONG("strong"),
        WEAK("weak");

        private String refType;

        private RefType(String refType) {
            this.refType = refType;
        }

        public String refType() {
            return this.refType;
        }
    }
}

