/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.ovsdb.rfc.schema.type;

import com.google.common.base.MoreObjects;
import com.google.common.collect.Sets;
import java.util.Objects;
import java.util.Set;
import org.onosproject.ovsdb.rfc.schema.type.BaseType;

public final class StringBaseType
implements BaseType {
    private final int minLength;
    private final int maxLength;
    private final Set<String> enums;

    public StringBaseType() {
        this.minLength = Integer.MIN_VALUE;
        this.maxLength = Integer.MAX_VALUE;
        this.enums = Sets.newHashSet();
    }

    public StringBaseType(int minLength, int maxLength, Set<String> enums) {
        this.minLength = minLength;
        this.maxLength = maxLength;
        this.enums = enums;
    }

    public int getMinLength() {
        return this.minLength;
    }

    public int getMaxLength() {
        return this.maxLength;
    }

    public Set<String> getEnums() {
        return this.enums;
    }

    public int hashCode() {
        return Objects.hash(this.minLength, this.maxLength, this.enums);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof StringBaseType) {
            StringBaseType other = (StringBaseType)obj;
            return Objects.equals(this.enums, other.enums) && Objects.equals(this.minLength, other.minLength) && Objects.equals(this.maxLength, other.maxLength);
        }
        return false;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("minLength", this.minLength).add("maxLength", this.maxLength).add("enums", this.enums).toString();
    }
}

