/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.ovsdb.rfc.schema.type;

import com.google.common.base.MoreObjects;
import com.google.common.collect.Sets;
import java.util.Objects;
import java.util.Set;
import org.onosproject.ovsdb.rfc.schema.type.BaseType;

public final class RealBaseType
implements BaseType {
    private final double min;
    private final double max;
    private final Set<Double> enums;

    public RealBaseType() {
        this.min = Double.MIN_VALUE;
        this.max = Double.MAX_VALUE;
        this.enums = Sets.newHashSet();
    }

    public RealBaseType(double min, double max, Set<Double> enums) {
        this.min = min;
        this.max = max;
        this.enums = enums;
    }

    public double getMin() {
        return this.min;
    }

    public double getMax() {
        return this.max;
    }

    public Set<Double> getEnums() {
        return this.enums;
    }

    public int hashCode() {
        return Objects.hash(this.min, this.max, this.enums);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof RealBaseType) {
            RealBaseType other = (RealBaseType)obj;
            return Objects.equals(this.enums, other.enums) && Objects.equals(this.min, other.min) && Objects.equals(this.max, other.max);
        }
        return false;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("min", this.min).add("max", this.max).add("enums", this.enums).toString();
    }
}

