/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.ovsdb.rfc.schema.type;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import java.util.Objects;
import org.onosproject.ovsdb.rfc.schema.type.BaseType;
import org.onosproject.ovsdb.rfc.schema.type.ColumnType;

public final class KeyValuedColumnType
implements ColumnType {
    private final BaseType keyType;
    private final BaseType valueType;
    private final int min;
    private final int max;

    public KeyValuedColumnType(BaseType keyType, BaseType valueType, int min, int max) {
        Preconditions.checkNotNull((Object)keyType, (Object)"keyType cannot be null");
        Preconditions.checkNotNull((Object)valueType, (Object)"valueType cannot be null");
        this.keyType = keyType;
        this.valueType = valueType;
        this.min = min;
        this.max = max;
    }

    public BaseType keyType() {
        return this.keyType;
    }

    public BaseType valueType() {
        return this.valueType;
    }

    public int min() {
        return this.min;
    }

    public int max() {
        return this.max;
    }

    public int hashCode() {
        return Objects.hash(this.keyType, this.valueType, this.min, this.max);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof KeyValuedColumnType) {
            KeyValuedColumnType other = (KeyValuedColumnType)obj;
            return Objects.equals(this.keyType, other.keyType) && Objects.equals(this.valueType, other.valueType) && Objects.equals(this.min, other.min) && Objects.equals(this.max, other.max);
        }
        return false;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("keyType", (Object)this.keyType).add("valueType", (Object)this.valueType).add("min", this.min).add("max", this.max).toString();
    }
}

