/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.ovsdb.rfc.schema.type;

import com.google.common.base.MoreObjects;
import com.google.common.collect.Sets;
import java.util.Objects;
import java.util.Set;
import org.onosproject.ovsdb.rfc.schema.type.BaseType;

public final class IntegerBaseType
implements BaseType {
    private final int min;
    private final int max;
    private final Set<Integer> enums;

    public IntegerBaseType() {
        this.min = Integer.MIN_VALUE;
        this.max = Integer.MAX_VALUE;
        this.enums = Sets.newHashSet();
    }

    public IntegerBaseType(int min, int max, Set<Integer> enums) {
        this.min = min;
        this.max = max;
        this.enums = enums;
    }

    public int min() {
        return this.min;
    }

    public int max() {
        return this.max;
    }

    public Set<Integer> enums() {
        return this.enums;
    }

    public int hashCode() {
        return Objects.hash(this.min, this.max, this.enums);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof IntegerBaseType) {
            IntegerBaseType other = (IntegerBaseType)obj;
            return Objects.equals(this.enums, other.enums) && Objects.equals(this.min, other.min) && Objects.equals(this.max, other.max);
        }
        return false;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("min", this.min).add("max", this.max).add("enums", this.enums).toString();
    }
}

