/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.ovsdb.rfc.schema.type;

import com.fasterxml.jackson.databind.JsonNode;
import org.onosproject.ovsdb.rfc.exception.AbnormalJsonNodeException;
import org.onosproject.ovsdb.rfc.schema.type.AtomicColumnType;
import org.onosproject.ovsdb.rfc.schema.type.BaseType;
import org.onosproject.ovsdb.rfc.schema.type.BaseTypeFactory;
import org.onosproject.ovsdb.rfc.schema.type.ColumnType;
import org.onosproject.ovsdb.rfc.schema.type.KeyValuedColumnType;
import org.onosproject.ovsdb.rfc.utils.ObjectMapperUtil;

public final class ColumnTypeFactory {
    private ColumnTypeFactory() {
    }

    public static ColumnType getColumnTypeFromJson(JsonNode columnTypeJson) {
        if (!columnTypeJson.isObject() || !columnTypeJson.has(Type.VALUE.type())) {
            return ColumnTypeFactory.createAtomicColumnType(columnTypeJson);
        }
        if (!columnTypeJson.isValueNode() && columnTypeJson.has(Type.VALUE.type())) {
            return ColumnTypeFactory.createKeyValuedColumnType(columnTypeJson);
        }
        String message = "Abnormal ColumnType JsonNode, it should be AtomicColumnType or KeyValuedColumnType" + ObjectMapperUtil.convertToString(columnTypeJson);
        throw new AbnormalJsonNodeException(message);
    }

    private static AtomicColumnType createAtomicColumnType(JsonNode json) {
        BaseType baseType = BaseTypeFactory.getBaseTypeFromJson(json, Type.KEY.type());
        int min = 1;
        int max = 1;
        JsonNode node = json.get("min");
        if (node != null && node.isNumber()) {
            min = node.asInt();
        }
        if ((node = json.get("max")) != null) {
            if (node.isNumber()) {
                max = node.asInt();
            } else if (node.isTextual() && "unlimited".equals(node.asText())) {
                max = Integer.MAX_VALUE;
            }
        }
        return new AtomicColumnType(baseType, min, max);
    }

    private static KeyValuedColumnType createKeyValuedColumnType(JsonNode json) {
        BaseType keyType = BaseTypeFactory.getBaseTypeFromJson(json, Type.KEY.type());
        BaseType valueType = BaseTypeFactory.getBaseTypeFromJson(json, Type.VALUE.type());
        int min = 1;
        int max = 1;
        JsonNode node = json.get("min");
        if (node != null && node.isNumber()) {
            min = node.asInt();
        }
        if ((node = json.get("max")) != null) {
            if (node.isNumber()) {
                max = node.asInt();
            } else if (node.isTextual() && "unlimited".equals(node.asText())) {
                max = Integer.MAX_VALUE;
            }
        }
        return new KeyValuedColumnType(keyType, valueType, min, max);
    }

    public static enum Type {
        KEY("key"),
        VALUE("value");

        private final String type;

        private Type(String type) {
            this.type = type;
        }

        public String type() {
            return this.type;
        }
    }
}

