/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.ovsdb.rfc.schema.type;

import com.fasterxml.jackson.databind.JsonNode;
import com.google.common.collect.Sets;
import java.util.HashSet;
import org.onosproject.ovsdb.rfc.exception.AbnormalJsonNodeException;
import org.onosproject.ovsdb.rfc.schema.type.BaseType;
import org.onosproject.ovsdb.rfc.schema.type.BooleanBaseType;
import org.onosproject.ovsdb.rfc.schema.type.IntegerBaseType;
import org.onosproject.ovsdb.rfc.schema.type.RealBaseType;
import org.onosproject.ovsdb.rfc.schema.type.StringBaseType;
import org.onosproject.ovsdb.rfc.schema.type.UuidBaseType;
import org.onosproject.ovsdb.rfc.utils.ObjectMapperUtil;

public final class BaseTypeFactory {
    private BaseTypeFactory() {
    }

    public static BaseType getBaseTypeFromJson(JsonNode baseTypeJson, String keyorval) {
        if (baseTypeJson.isValueNode()) {
            String type = baseTypeJson.asText().trim();
            return BaseTypeFactory.fromTypeStr(type);
        }
        if (!baseTypeJson.has(keyorval)) {
            String message = "Abnormal BaseType JsonNode, it should contain 'key' or 'value' node but was not found" + ObjectMapperUtil.convertToString(baseTypeJson);
            throw new AbnormalJsonNodeException(message);
        }
        return BaseTypeFactory.fromJsonNode(baseTypeJson.get(keyorval));
    }

    private static BaseType fromTypeStr(String type) {
        switch (type) {
            case "boolean": {
                return new BooleanBaseType();
            }
            case "integer": {
                return new IntegerBaseType();
            }
            case "real": {
                return new RealBaseType();
            }
            case "string": {
                return new StringBaseType();
            }
            case "uuid": {
                return new UuidBaseType();
            }
        }
        return null;
    }

    private static BaseType fromJsonNode(JsonNode type) {
        if (type.isTextual()) {
            return BaseTypeFactory.fromTypeStr(type.asText());
        }
        if (type.isObject() && type.has("type")) {
            String typeStr;
            switch (typeStr = type.get("type").asText()) {
                case "boolean": {
                    return new BooleanBaseType();
                }
                case "integer": {
                    return BaseTypeFactory.getIntegerBaseType(type);
                }
                case "real": {
                    return BaseTypeFactory.getRealBaseType(type);
                }
                case "string": {
                    return BaseTypeFactory.getStringBaseType(type);
                }
                case "uuid": {
                    return BaseTypeFactory.getUuidBaseType(type);
                }
            }
            return null;
        }
        return null;
    }

    private static IntegerBaseType getIntegerBaseType(JsonNode type) {
        int min = Integer.MIN_VALUE;
        int max = Integer.MAX_VALUE;
        HashSet enums = Sets.newHashSet();
        JsonNode node = type.get("minInteger");
        if (node != null) {
            min = node.asInt();
        }
        if ((node = type.get("maxInteger")) != null) {
            max = node.asInt();
        }
        if (type.has("enum")) {
            JsonNode anEnum = type.get("enum").get(1);
            for (JsonNode n : anEnum) {
                enums.add(n.asInt());
            }
        }
        return new IntegerBaseType(min, max, enums);
    }

    private static RealBaseType getRealBaseType(JsonNode type) {
        double min = Double.MIN_VALUE;
        double max = Double.MAX_VALUE;
        HashSet enums = Sets.newHashSet();
        JsonNode node = type.get("minReal");
        if (node != null) {
            min = node.asDouble();
        }
        if ((node = type.get("maxReal")) != null) {
            max = node.asDouble();
        }
        if (type.has("enum")) {
            JsonNode anEnum = type.get("enum").get(1);
            for (JsonNode n : anEnum) {
                enums.add(n.asDouble());
            }
        }
        return new RealBaseType(min, max, enums);
    }

    private static StringBaseType getStringBaseType(JsonNode type) {
        int minLength = Integer.MIN_VALUE;
        int maxLength = Integer.MAX_VALUE;
        HashSet enums = Sets.newHashSet();
        JsonNode node = type.get("minLength");
        if (node != null) {
            minLength = node.asInt();
        }
        if ((node = type.get("maxLength")) != null) {
            maxLength = node.asInt();
        }
        if (type.has("enum")) {
            JsonNode enumVal = type.get("enum");
            if (enumVal.isArray()) {
                JsonNode anEnum = enumVal.get(1);
                for (JsonNode n : anEnum) {
                    enums.add(n.asText());
                }
            } else if (enumVal.isTextual()) {
                enums.add(enumVal.asText());
            }
        }
        return new StringBaseType(minLength, maxLength, enums);
    }

    private static UuidBaseType getUuidBaseType(JsonNode type) {
        String refTable = null;
        String refType = UuidBaseType.RefType.STRONG.refType();
        JsonNode node = type.get("refTable");
        if (node != null) {
            refTable = node.asText();
        }
        if ((node = type.get("refType")) != null) {
            refType = node.asText();
        }
        return new UuidBaseType(refTable, refType);
    }
}

