/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.ovsdb.rfc.schema.type;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import java.util.Objects;
import org.onosproject.ovsdb.rfc.schema.type.BaseType;
import org.onosproject.ovsdb.rfc.schema.type.ColumnType;

public final class AtomicColumnType
implements ColumnType {
    private final BaseType baseType;
    private final int min;
    private final int max;

    public AtomicColumnType(BaseType baseType) {
        Preconditions.checkNotNull((Object)baseType, (Object)"BaseType cannot be null");
        this.baseType = baseType;
        this.min = 1;
        this.max = 1;
    }

    public AtomicColumnType(BaseType baseType, int min, int max) {
        Preconditions.checkNotNull((Object)baseType, (Object)"BaseType cannot be null");
        this.baseType = baseType;
        this.min = min;
        this.max = max;
    }

    public BaseType baseType() {
        return this.baseType;
    }

    public int min() {
        return this.min;
    }

    public int max() {
        return this.max;
    }

    public int hashCode() {
        return Objects.hash(this.baseType, this.min, this.max);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof AtomicColumnType) {
            AtomicColumnType other = (AtomicColumnType)obj;
            return Objects.equals(this.baseType, other.baseType) && Objects.equals(this.min, other.min) && Objects.equals(this.max, other.max);
        }
        return false;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("baseType", (Object)this.baseType).add("min", this.min).add("max", this.max).toString();
    }
}

