/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.ovsdb.rfc.schema;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.onosproject.ovsdb.rfc.schema.ColumnSchema;
import org.onosproject.ovsdb.rfc.schema.type.AtomicColumnType;
import org.onosproject.ovsdb.rfc.schema.type.UuidBaseType;

public final class TableSchema {
    private final String name;
    private final Map<String, ColumnSchema> columnSchemas;

    public TableSchema(String name, Map<String, ColumnSchema> columnSchemas) {
        Preconditions.checkNotNull((Object)name, (Object)"name cannot be null");
        Preconditions.checkNotNull(columnSchemas, (Object)"columnSchemas cannot be null");
        this.name = name;
        this.columnSchemas = columnSchemas;
    }

    public String name() {
        return this.name;
    }

    public Map<String, ColumnSchema> columnSchemas() {
        return this.columnSchemas;
    }

    public Set<String> getColumnNames() {
        return this.columnSchemas.keySet();
    }

    public boolean hasColumn(String columnName) {
        return this.getColumnNames().contains(columnName);
    }

    public ColumnSchema getColumnSchema(String columnName) {
        return this.columnSchemas.get(columnName);
    }

    public void generateInitializationColumns() {
        this.columnSchemas.put("_uuid", new ColumnSchema("_uuid", new AtomicColumnType(new UuidBaseType())));
        this.columnSchemas.put("_version", new ColumnSchema("_version", new AtomicColumnType(new UuidBaseType())));
    }

    public int hashCode() {
        return Objects.hash(this.name, this.columnSchemas);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof TableSchema) {
            TableSchema other = (TableSchema)obj;
            return Objects.equals(this.name, other.name) && Objects.equals(this.columnSchemas, other.columnSchemas);
        }
        return false;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("name", (Object)this.name).add("columnSchemas", this.columnSchemas).toString();
    }
}

