/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.ovsdb.rfc.schema;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.onosproject.ovsdb.rfc.schema.TableSchema;

public final class DatabaseSchema {
    private final String name;
    private final String version;
    private final Map<String, TableSchema> tableSchemas;

    public DatabaseSchema(String name, String version, Map<String, TableSchema> tableSchemas) {
        Preconditions.checkNotNull((Object)name, (Object)"name cannot be null");
        Preconditions.checkNotNull((Object)version, (Object)"version cannot be null");
        Preconditions.checkNotNull(tableSchemas, (Object)"tableSchemas cannot be null");
        this.name = name;
        this.version = version;
        this.tableSchemas = tableSchemas;
    }

    public String name() {
        return this.name;
    }

    public String version() {
        return this.version;
    }

    public Map<String, TableSchema> tableSchemas() {
        return this.tableSchemas;
    }

    public Set<String> getTableNames() {
        return this.tableSchemas.keySet();
    }

    public boolean hasTable(String tableName) {
        return this.getTableNames().contains(tableName);
    }

    public TableSchema getTableSchema(String tableName) {
        TableSchema table = this.tableSchemas.get(tableName);
        return table;
    }

    public void generateInitializationColumns() {
        for (TableSchema tableSchema : this.tableSchemas.values()) {
            tableSchema.generateInitializationColumns();
        }
    }

    public int hashCode() {
        return Objects.hash(this.name, this.version, this.tableSchemas);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof DatabaseSchema) {
            DatabaseSchema other = (DatabaseSchema)obj;
            return Objects.equals(this.name, other.name) && Objects.equals(this.version, other.version) && Objects.equals(this.tableSchemas, other.tableSchemas);
        }
        return false;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("name", (Object)this.name).add("version", (Object)this.version).add("tableSchemas", this.tableSchemas).toString();
    }
}

