/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.ovsdb.rfc.schema;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import java.util.Objects;
import org.onosproject.ovsdb.rfc.schema.type.ColumnType;

public final class ColumnSchema {
    private final String name;
    private final ColumnType type;

    public ColumnSchema(String name, ColumnType columnType) {
        Preconditions.checkNotNull((Object)name, (Object)"name cannot be null");
        Preconditions.checkNotNull((Object)columnType, (Object)"column type cannot be null");
        this.name = name;
        this.type = columnType;
    }

    public String name() {
        return this.name;
    }

    public ColumnType type() {
        return this.type;
    }

    public int hashCode() {
        return Objects.hash(this.name, this.type);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof ColumnSchema) {
            ColumnSchema other = (ColumnSchema)obj;
            return Objects.equals(this.name, other.name) && Objects.equals(this.type, other.type);
        }
        return false;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("name", (Object)this.name).add("type", (Object)this.type).toString();
    }
}

