/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.ovsdb.rfc.operations;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Preconditions;
import com.google.common.collect.Maps;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.onosproject.ovsdb.rfc.notation.Column;
import org.onosproject.ovsdb.rfc.notation.Condition;
import org.onosproject.ovsdb.rfc.notation.Row;
import org.onosproject.ovsdb.rfc.operations.Operation;
import org.onosproject.ovsdb.rfc.schema.TableSchema;
import org.onosproject.ovsdb.rfc.utils.TransValueUtil;

public final class Update
implements Operation {
    @JsonIgnore
    private final TableSchema tableSchema;
    private final String op;
    private final Map<String, Object> row;
    private final List<Condition> where;

    public Update(TableSchema schema, Row row, List<Condition> where) {
        Preconditions.checkNotNull((Object)schema, (Object)"TableSchema cannot be null");
        Preconditions.checkNotNull((Object)row, (Object)"row cannot be null");
        Preconditions.checkNotNull(where, (Object)"where cannot be null");
        this.tableSchema = schema;
        this.op = Operation.Operations.UPDATE.op();
        this.row = Maps.newHashMap();
        this.where = where;
        this.generateOperationRow(row);
    }

    private void generateOperationRow(Row row) {
        Collection<Column> columns = row.getColumns();
        for (Column column : columns) {
            String columnName = column.columnName();
            Object value = column.data();
            Object formatValue = TransValueUtil.getFormatData(value);
            this.row.put(columnName, formatValue);
        }
    }

    public Map<String, Object> getRow() {
        return this.row;
    }

    public List<Condition> getWhere() {
        return this.where;
    }

    @Override
    public String getOp() {
        return this.op;
    }

    @Override
    public TableSchema getTableSchema() {
        return this.tableSchema;
    }

    @JsonProperty
    public String getTable() {
        return this.tableSchema.name();
    }
}

