/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.ovsdb.rfc.operations;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Preconditions;
import java.util.List;
import org.onosproject.ovsdb.rfc.notation.Condition;
import org.onosproject.ovsdb.rfc.notation.Mutation;
import org.onosproject.ovsdb.rfc.operations.Operation;
import org.onosproject.ovsdb.rfc.schema.TableSchema;

public final class Mutate
implements Operation {
    @JsonIgnore
    private final TableSchema tableSchema;
    private final String op;
    private final List<Condition> where;
    private final List<Mutation> mutations;

    public Mutate(TableSchema schema, List<Condition> where, List<Mutation> mutations) {
        Preconditions.checkNotNull((Object)schema, (Object)"TableSchema cannot be null");
        Preconditions.checkNotNull(mutations, (Object)"mutations cannot be null");
        Preconditions.checkNotNull(where, (Object)"where cannot be null");
        this.tableSchema = schema;
        this.op = Operation.Operations.MUTATE.op();
        this.where = where;
        this.mutations = mutations;
    }

    public List<Mutation> getMutations() {
        return this.mutations;
    }

    public List<Condition> getWhere() {
        return this.where;
    }

    @Override
    public String getOp() {
        return this.op;
    }

    @Override
    public TableSchema getTableSchema() {
        return this.tableSchema;
    }

    @JsonProperty
    public String getTable() {
        return this.tableSchema.name();
    }
}

