/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.ovsdb.rfc.operations;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Preconditions;
import com.google.common.collect.Maps;
import java.util.Collection;
import java.util.Map;
import org.onosproject.ovsdb.rfc.notation.Column;
import org.onosproject.ovsdb.rfc.notation.Row;
import org.onosproject.ovsdb.rfc.operations.Operation;
import org.onosproject.ovsdb.rfc.schema.TableSchema;
import org.onosproject.ovsdb.rfc.utils.TransValueUtil;

public final class Insert
implements Operation {
    @JsonIgnore
    private final TableSchema tableSchema;
    private final String op;
    @JsonProperty(value="uuid-name")
    private final String uuidName;
    private final Map<String, Object> row;

    public Insert(TableSchema schema, String uuidName, Row row) {
        Preconditions.checkNotNull((Object)schema, (Object)"TableSchema cannot be null");
        Preconditions.checkNotNull((Object)uuidName, (Object)"uuid name cannot be null");
        Preconditions.checkNotNull((Object)row, (Object)"row cannot be null");
        this.tableSchema = schema;
        this.op = Operation.Operations.INSERT.op();
        this.uuidName = uuidName;
        this.row = Maps.newHashMap();
        this.generateOperationRow(row);
    }

    private void generateOperationRow(Row row) {
        Collection<Column> columns = row.getColumns();
        for (Column column : columns) {
            String columnName = column.columnName();
            Object value = column.data();
            Object formatValue = TransValueUtil.getFormatData(value);
            this.row.put(columnName, formatValue);
        }
    }

    public String getUuidName() {
        return this.uuidName;
    }

    public Map<String, Object> getRow() {
        return this.row;
    }

    @Override
    public String getOp() {
        return this.op;
    }

    @Override
    public TableSchema getTableSchema() {
        return this.tableSchema;
    }

    @JsonProperty
    public String getTable() {
        return this.tableSchema.name();
    }
}

