/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.ovsdb.rfc.notation;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import java.util.Objects;
import org.onosproject.ovsdb.rfc.notation.json.UuidConverter;
import org.onosproject.ovsdb.rfc.notation.json.UuidSerializer;

@JsonSerialize(using=UuidSerializer.class)
@JsonDeserialize(converter=UuidConverter.class)
public final class Uuid {
    private final String value;

    private Uuid(String value) {
        Preconditions.checkNotNull((Object)value, (Object)"value cannot be null");
        this.value = value;
    }

    public static Uuid uuid(String value) {
        return new Uuid(value);
    }

    public String value() {
        return this.value;
    }

    public int hashCode() {
        return this.value.hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof Uuid) {
            Uuid other = (Uuid)obj;
            return Objects.equals(this.value, other.value);
        }
        return false;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("value", (Object)this.value).toString();
    }
}

