/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.ovsdb.rfc.notation;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.collect.Maps;
import java.util.Collection;
import java.util.Map;
import java.util.Objects;
import org.onosproject.ovsdb.rfc.notation.Column;
import org.onosproject.ovsdb.rfc.notation.Uuid;

public final class Row {
    private String tableName;
    private Uuid uuid;
    private Map<String, Column> columns;

    public Row() {
        this.columns = Maps.newHashMap();
    }

    public Row(String tableName, Uuid uuid, Map<String, Column> columns) {
        Preconditions.checkNotNull((Object)tableName, (Object)"table name cannot be null");
        Preconditions.checkNotNull((Object)uuid, (Object)"uuid cannot be null");
        Preconditions.checkNotNull(columns, (Object)"columns cannot be null");
        this.tableName = tableName;
        this.uuid = uuid;
        this.columns = columns;
    }

    public String tableName() {
        return this.tableName;
    }

    public void setTableName(String tableName) {
        this.tableName = tableName;
    }

    public Uuid uuid() {
        return this.uuid;
    }

    public void setUuid(Uuid uuid) {
        this.uuid = uuid;
    }

    public Column getColumn(String columnName) {
        return this.columns.get(columnName);
    }

    public Collection<Column> getColumns() {
        return this.columns.values();
    }

    public void addColumn(String columnName, Column data) {
        this.columns.put(columnName, data);
    }

    public int hashCode() {
        return Objects.hash(this.tableName, this.columns);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof Row) {
            Row other = (Row)obj;
            return Objects.equals(this.tableName, other.tableName) && Objects.equals(this.columns, other.columns);
        }
        return false;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("tableName", (Object)this.tableName).add("columns", this.columns).toString();
    }
}

