/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.ovsdb.rfc.notation;

import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import java.util.Objects;
import org.onosproject.ovsdb.rfc.notation.json.MutationSerializer;

@JsonSerialize(using=MutationSerializer.class)
public final class Mutation {
    private final String column;
    private final Mutator mutator;
    private final Object value;

    public Mutation(String column, Mutator mutator, Object value) {
        Preconditions.checkNotNull((Object)column, (Object)"column cannot be null");
        Preconditions.checkNotNull((Object)((Object)mutator), (Object)"mutator cannot be null");
        Preconditions.checkNotNull((Object)value, (Object)"value cannot be null");
        this.column = column;
        this.mutator = mutator;
        this.value = value;
    }

    public String getColumn() {
        return this.column;
    }

    public Mutator getMutator() {
        return this.mutator;
    }

    public Object getValue() {
        return this.value;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.column, this.mutator, this.value});
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof Mutation) {
            Mutation other = (Mutation)obj;
            return Objects.equals(this.column, other.column) && Objects.equals((Object)this.mutator, (Object)other.mutator) && Objects.equals(this.value, other.value);
        }
        return false;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("column", (Object)this.column).add("mutator", (Object)this.mutator).add("value", this.value).toString();
    }

    public static enum Mutator {
        SUM("+="),
        DIFFERENCE("-="),
        PRODUCT("*="),
        QUOTIENT("/="),
        REMAINDER("%="),
        INSERT("insert"),
        DELETE("delete");

        private final String mutator;

        private Mutator(String mutator) {
            this.mutator = mutator;
        }

        public String mutator() {
            return this.mutator;
        }
    }
}

