/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.ovsdb.rfc.notation;

import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import java.util.Objects;
import org.onosproject.ovsdb.rfc.notation.json.ConditionSerializer;

@JsonSerialize(using=ConditionSerializer.class)
public final class Condition {
    private final String column;
    private final Function function;
    private final Object value;

    public Condition(String column, Function function, Object value) {
        Preconditions.checkNotNull((Object)column, (Object)"column cannot be null");
        Preconditions.checkNotNull((Object)((Object)function), (Object)"function cannot be null");
        Preconditions.checkNotNull((Object)value, (Object)"value cannot be null");
        this.column = column;
        this.function = function;
        this.value = value;
    }

    public String getColumn() {
        return this.column;
    }

    public Function getFunction() {
        return this.function;
    }

    public Object getValue() {
        return this.value;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.column, this.function, this.value});
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof Condition) {
            Condition other = (Condition)obj;
            return Objects.equals(this.column, other.column) && Objects.equals((Object)this.function, (Object)other.function) && Objects.equals(this.value, other.value);
        }
        return false;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("column", (Object)this.column).add("function", (Object)this.function).add("value", this.value).toString();
    }

    public static enum Function {
        LESS_THAN("<"),
        LESS_THAN_OR_EQUALS("<="),
        EQUALS("=="),
        NOT_EQUALS("!="),
        GREATER_THAN(">"),
        GREATER_THAN_OR_EQUALS(">="),
        INCLUDES("includes"),
        EXCLUDES("excludes");

        private final String function;

        private Function(String function) {
            this.function = function;
        }

        public String function() {
            return this.function;
        }
    }
}

