/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.ovsdb.rfc.message;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import java.util.Map;
import java.util.Objects;
import org.onosproject.ovsdb.rfc.message.TableUpdate;
import org.onosproject.ovsdb.rfc.schema.TableSchema;

public final class TableUpdates {
    private final Map<String, TableUpdate> result;

    private TableUpdates(Map<String, TableUpdate> result) {
        this.result = result;
    }

    public static TableUpdates tableUpdates(Map<String, TableUpdate> result) {
        Preconditions.checkNotNull(result, (Object)"result cannot be null");
        return new TableUpdates(result);
    }

    public TableUpdate tableUpdate(TableSchema table) {
        return this.result.get(table.name());
    }

    public Map<String, TableUpdate> result() {
        return this.result;
    }

    public int hashCode() {
        return this.result.hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof TableUpdates) {
            TableUpdates other = (TableUpdates)obj;
            return Objects.equals(this.result, other.result);
        }
        return false;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("result", this.result).toString();
    }
}

