/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.ovsdb.rfc.message;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import java.util.Map;
import java.util.Objects;
import org.onosproject.ovsdb.rfc.message.RowUpdate;
import org.onosproject.ovsdb.rfc.notation.Row;
import org.onosproject.ovsdb.rfc.notation.Uuid;

public final class TableUpdate {
    private final Map<Uuid, RowUpdate> rows;

    private TableUpdate(Map<Uuid, RowUpdate> rows) {
        this.rows = rows;
    }

    public static TableUpdate tableUpdate(Map<Uuid, RowUpdate> rows) {
        Preconditions.checkNotNull(rows, (Object)"rows cannot be null");
        return new TableUpdate(rows);
    }

    public Row getOld(Uuid uuid) {
        RowUpdate rowUpdate = this.rows.get(uuid);
        if (rowUpdate == null) {
            return null;
        }
        return rowUpdate.oldRow();
    }

    public Row getNew(Uuid uuid) {
        RowUpdate rowUpdate = this.rows.get(uuid);
        if (rowUpdate == null) {
            return null;
        }
        return rowUpdate.newRow();
    }

    public Map<Uuid, RowUpdate> rows() {
        return this.rows;
    }

    public int hashCode() {
        return this.rows.hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof TableUpdate) {
            TableUpdate other = (TableUpdate)obj;
            return Objects.equals(this.rows, other.rows);
        }
        return false;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("rows", this.rows).toString();
    }
}

