/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.ovsdb.rfc.message;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import java.util.Objects;
import org.onosproject.ovsdb.rfc.notation.Row;
import org.onosproject.ovsdb.rfc.notation.Uuid;

public final class RowUpdate {
    private final Uuid uuid;
    private final Row oldRow;
    private final Row newRow;

    public RowUpdate(Uuid uuid, Row oldRow, Row newRow) {
        Preconditions.checkNotNull((Object)uuid, (Object)"uuid cannot be null");
        this.uuid = uuid;
        this.oldRow = oldRow;
        this.newRow = newRow;
    }

    public Uuid uuid() {
        return this.uuid;
    }

    public Row oldRow() {
        return this.oldRow;
    }

    public Row newRow() {
        return this.newRow;
    }

    public int hashCode() {
        return Objects.hash(this.uuid, this.oldRow, this.newRow);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof RowUpdate) {
            RowUpdate other = (RowUpdate)obj;
            return Objects.equals(this.uuid, other.uuid) && Objects.equals(this.oldRow, other.oldRow) && Objects.equals(this.newRow, other.newRow);
        }
        return false;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("uuid", (Object)this.uuid).add("oldRow", (Object)this.oldRow).add("newRow", (Object)this.newRow).toString();
    }
}

