/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.ovsdb.rfc.message;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import java.util.Objects;
import java.util.Set;
import org.onosproject.ovsdb.rfc.message.MonitorSelect;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
public final class MonitorRequest {
    @JsonIgnore
    private final String tableName;
    private final Set<String> columns;
    private final MonitorSelect select;

    public MonitorRequest(String tableName, Set<String> columns, MonitorSelect select) {
        Preconditions.checkNotNull((Object)tableName, (Object)"table name cannot be null");
        Preconditions.checkNotNull(columns, (Object)"columns cannot be null");
        Preconditions.checkNotNull((Object)select, (Object)"select cannot be null");
        this.tableName = tableName;
        this.columns = columns;
        this.select = select;
    }

    public String getTableName() {
        return this.tableName;
    }

    public MonitorSelect getSelect() {
        return this.select;
    }

    public Set<String> getColumns() {
        return this.columns;
    }

    public int hashCode() {
        return Objects.hash(this.tableName, this.select, this.columns);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof MonitorRequest) {
            MonitorRequest other = (MonitorRequest)obj;
            return Objects.equals(this.tableName, other.tableName) && Objects.equals(this.select, other.select) && Objects.equals(this.columns, other.columns);
        }
        return false;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("tableName", (Object)this.tableName).add("select", (Object)this.select).add("columns", this.columns).toString();
    }
}

