/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.ovsdb.rfc.jsonrpc;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import java.util.List;
import java.util.Objects;

public class JsonRpcResponse {
    private final String id;
    private final String error;
    private final List<Object> result;

    public JsonRpcResponse(String id) {
        Preconditions.checkNotNull((Object)id, (Object)"id cannot be null");
        this.id = id;
        this.error = null;
        this.result = Lists.newArrayList();
    }

    public JsonRpcResponse(String id, String error) {
        Preconditions.checkNotNull((Object)id, (Object)"id cannot be null");
        Preconditions.checkNotNull((Object)error, (Object)"error cannot be null");
        this.id = id;
        this.error = error;
        this.result = Lists.newArrayList();
    }

    public JsonRpcResponse(String id, String error, List<Object> result) {
        Preconditions.checkNotNull((Object)id, (Object)"id cannot be null");
        Preconditions.checkNotNull((Object)error, (Object)"error cannot be null");
        Preconditions.checkNotNull(result, (Object)"result cannot be null");
        this.id = id;
        this.error = error;
        this.result = result;
    }

    public String getId() {
        return this.id;
    }

    public String getError() {
        return this.error;
    }

    public List<Object> getResult() {
        return this.result;
    }

    public int hashCode() {
        return Objects.hash(this.id, this.error, this.result);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof JsonRpcResponse) {
            JsonRpcResponse other = (JsonRpcResponse)obj;
            return Objects.equals(this.id, other.id) && Objects.equals(this.error, other.error) && Objects.equals(this.result, other.result);
        }
        return false;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("id", (Object)this.id).add("error", (Object)this.error).add("result", this.result).toString();
    }
}

