/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.ovsdb.rfc.jsonrpc;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import java.util.List;
import java.util.Objects;

public class JsonRpcRequest {
    private final String id;
    private final String method;
    private final List<Object> params;

    public JsonRpcRequest(String id, String method) {
        Preconditions.checkNotNull((Object)id, (Object)"id cannot be null");
        Preconditions.checkNotNull((Object)method, (Object)"method cannot be null");
        this.id = id;
        this.method = method;
        this.params = Lists.newArrayList();
    }

    public JsonRpcRequest(String id, String method, List<Object> params) {
        Preconditions.checkNotNull((Object)id, (Object)"id cannot be null");
        Preconditions.checkNotNull((Object)method, (Object)"method cannot be null");
        Preconditions.checkNotNull(params, (Object)"params cannot be null");
        this.id = id;
        this.method = method;
        this.params = params;
    }

    public String getId() {
        return this.id;
    }

    public String getMethod() {
        return this.method;
    }

    public List<Object> getParams() {
        return this.params;
    }

    public int hashCode() {
        return Objects.hash(this.id, this.method, this.params);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof JsonRpcRequest) {
            JsonRpcRequest other = (JsonRpcRequest)obj;
            return Objects.equals(this.id, other.id) && Objects.equals(this.method, other.method) && Objects.equals(this.params, other.params);
        }
        return false;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("id", (Object)this.id).add("method", (Object)this.method).add("params", this.params).toString();
    }
}

