/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.provider.netconf.alarm;

import com.google.common.collect.ImmutableSet;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Collection;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.joda.time.format.ISODateTimeFormat;
import org.onosproject.incubator.net.faultmanagement.alarm.Alarm;
import org.onosproject.incubator.net.faultmanagement.alarm.AlarmTranslator;
import org.onosproject.incubator.net.faultmanagement.alarm.DefaultAlarm;
import org.onosproject.net.DeviceId;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class NetconfAlarmTranslator
implements AlarmTranslator {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private static final String EVENTTIME_TAGNAME = "eventTime";

    public Collection<Alarm> translateToAlarm(DeviceId deviceId, InputStream message) {
        try {
            ArrayList<Alarm> alarms = new ArrayList<Alarm>();
            Document doc = this.createDocFromMessage(message);
            Node eventTime = doc.getElementsByTagName(EVENTTIME_TAGNAME).item(0);
            String date = eventTime.getTextContent();
            long timeStamp = this.parseDate(date);
            Node descriptionNode = eventTime.getNextSibling();
            while (descriptionNode != null) {
                if (descriptionNode.getNodeType() == 1) {
                    String description = NetconfAlarmTranslator.nodeToString(descriptionNode);
                    alarms.add((Alarm)new DefaultAlarm.Builder(deviceId, description, Alarm.SeverityLevel.WARNING, timeStamp).build());
                    descriptionNode = null;
                    continue;
                }
                descriptionNode = descriptionNode.getNextSibling();
            }
            return alarms;
        }
        catch (IOException | IllegalArgumentException | UnsupportedOperationException | ParserConfigurationException | TransformerException | SAXException e) {
            this.log.error("Exception thrown translating message from {}.", (Object)deviceId, (Object)e);
            return ImmutableSet.of();
        }
    }

    private Document createDocFromMessage(InputStream message) throws SAXException, IOException, ParserConfigurationException {
        DocumentBuilderFactory dbfactory = DocumentBuilderFactory.newInstance();
        DocumentBuilder builder = dbfactory.newDocumentBuilder();
        return builder.parse(new InputSource(message));
    }

    private long parseDate(String timeStr) throws UnsupportedOperationException, IllegalArgumentException {
        return ISODateTimeFormat.dateTime().parseMillis(timeStr);
    }

    private static String nodeToString(Node rootNode) throws TransformerException {
        TransformerFactory tf = TransformerFactory.newInstance();
        Transformer transformer = tf.newTransformer();
        transformer.setOutputProperty("omit-xml-declaration", "yes");
        StringWriter writer = new StringWriter();
        DOMSource source = new DOMSource(rootNode);
        transformer.transform(source, new StreamResult(writer));
        return writer.getBuffer().toString();
    }
}

