/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.incubator.component.impl;

import java.util.Collections;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.apache.felix.scr.ScrService;
import org.apache.felix.scr.annotations.Activate;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Deactivate;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.ReferenceCardinality;
import org.apache.felix.scr.annotations.Service;
import org.onlab.util.Tools;
import org.onosproject.core.ApplicationId;
import org.onosproject.incubator.component.ComponentService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Service
@Component(immediate=true)
public class ComponentManager
implements ComponentService {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private static final int POLLING_PERIOD_MS = 500;
    private static final int NUM_THREADS = 1;
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected ScrService scrService;
    private Set<String> components;
    private ScheduledExecutorService executor;

    @Activate
    private void activate() {
        this.components = Collections.newSetFromMap(new ConcurrentHashMap());
        this.executor = Executors.newScheduledThreadPool(1, Tools.groupedThreads((String)"onos/component", (String)"%d", (Logger)this.log));
        this.executor.scheduleAtFixedRate(() -> this.components.forEach(this::enableComponent), 0L, 500L, TimeUnit.MILLISECONDS);
        this.log.info("Started");
    }

    @Deactivate
    private void deactivate() {
        this.executor.shutdownNow();
        this.log.info("Stopped");
    }

    public void activate(ApplicationId appId, String name) {
        this.components.add(name);
        this.enableComponent(name);
    }

    public void deactivate(ApplicationId appId, String name) {
        this.components.remove(name);
        this.disableComponent(name);
    }

    private void enableComponent(String name) {
        org.apache.felix.scr.Component[] components = this.scrService.getComponents(name);
        if (components == null || components.length == 0) {
            return;
        }
        org.apache.felix.scr.Component component = components[0];
        if (component.getState() == 1) {
            this.log.info("Enabling component {}", (Object)name);
            component.enable();
        }
    }

    private void disableComponent(String name) {
        org.apache.felix.scr.Component[] components = this.scrService.getComponents(name);
        if (components == null || components.length == 0) {
            return;
        }
        this.log.info("Disabling component {}", (Object)name);
        components[0].disable();
    }

    protected void bindScrService(ScrService scrService) {
        this.scrService = scrService;
    }

    protected void unbindScrService(ScrService scrService) {
        if (this.scrService == scrService) {
            this.scrService = null;
        }
    }
}

