/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.drivers.fujitsu.cli;

import org.apache.karaf.shell.commands.Argument;
import org.apache.karaf.shell.commands.Command;
import org.onosproject.cli.AbstractShellCommand;
import org.onosproject.drivers.fujitsu.behaviour.VoltFwdlConfig;
import org.onosproject.net.DeviceId;
import org.onosproject.net.driver.DriverHandler;
import org.onosproject.net.driver.DriverService;

@Command(scope="onos", name="volt-ondemandfwdl", description="Requests manual firmware upgrade on a list of ONUs in vOLT")
public class VoltOndemandFwdlCommand
extends AbstractShellCommand {
    @Argument(index=0, name="uri", description="Device ID", required=true, multiValued=false)
    String uri = null;
    @Argument(index=1, name="target", description="image name:PON link ID-ONU ID[,PON link ID-ONU ID,..:reboot-mode]", required=true, multiValued=false)
    String target = null;
    private DeviceId deviceId;

    protected void execute() {
        DriverService service = (DriverService)VoltOndemandFwdlCommand.get(DriverService.class);
        this.deviceId = DeviceId.deviceId((String)this.uri);
        DriverHandler h = service.createHandler(this.deviceId, new String[0]);
        VoltFwdlConfig volt = (VoltFwdlConfig)h.behaviour(VoltFwdlConfig.class);
        String reply = volt.upgradeFirmwareOndemand(this.target);
        if (reply != null) {
            this.print("%s", new Object[]{reply});
        } else {
            this.print("ONU firmware-upgrade failure %s", new Object[]{this.deviceId.toString()});
        }
    }
}

