/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.drivers.fujitsu;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.onosproject.drivers.fujitsu.FujitsuVoltXmlUtility;
import org.onosproject.drivers.fujitsu.behaviour.VoltPonLinkConfig;
import org.onosproject.mastership.MastershipService;
import org.onosproject.net.DeviceId;
import org.onosproject.net.driver.AbstractHandlerBehaviour;
import org.onosproject.net.driver.DriverHandler;
import org.onosproject.netconf.NetconfController;
import org.onosproject.netconf.NetconfDevice;
import org.onosproject.netconf.TargetConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FujitsuVoltPonLinkConfig
extends AbstractHandlerBehaviour
implements VoltPonLinkConfig {
    private final Logger log = LoggerFactory.getLogger(FujitsuVoltPonLinkConfig.class);
    private static final Map<String, List<Integer>> PON_LINK_PARAMS = new HashMap<String, List<Integer>>(){
        {
            this.put("onu-discovery-interval", Arrays.asList(1, 3600));
            this.put("dba-cycle-time", Arrays.asList(2, 40));
            this.put("mac-age-time", Arrays.asList(1000, 3600000));
            this.put("lof-threshold", Arrays.asList(1, 10));
            this.put("los-threshold", Arrays.asList(1, 10));
            this.put(FujitsuVoltPonLinkConfig.ONU_DISCOVERY_MODE, null);
            this.put(FujitsuVoltPonLinkConfig.PM_ENABLE, null);
            this.put(FujitsuVoltPonLinkConfig.ADMIN_STATE, null);
            this.put(FujitsuVoltPonLinkConfig.LOOPBACK_ENABLE, null);
        }
    };
    private static final String VOLT_PORTS = "volt-ports";
    private static final String GPON_PONLINK_PORTS = "gpon-ponlink-ports";
    private static final String GPON_PONLINK_PORT = "gpon-ponlink-port";
    private static final String ADMIN_STATE = "admin-state";
    private static final String ONU_DISCOVERY_MODE = "onu-discovery-mode";
    private static final String PM_ENABLE = "pm-enable";
    private static final String LOOPBACK_ENABLE = "loopback-enable";
    private static final Set<String> ADMINSTATES = ImmutableSet.of((Object)"enable", (Object)"disable");
    private static final Set<String> ONUDISCOVERYMODES = ImmutableSet.of((Object)"auto", (Object)"manual", (Object)"disabled");
    private static final Set<String> PMENABLES = ImmutableSet.of((Object)"true", (Object)"false");
    private static final Set<String> LOOPBACKENABLES = ImmutableSet.of((Object)"true", (Object)"false");
    private static final int ONU_DISCOVERY_INTERVAL_MIN = 1;
    private static final int ONU_DISCOVERY_INTERVAL_MAX = 3600;
    private static final int DBA_CYCLE_TIME_MIN = 2;
    private static final int DBA_CYCLE_TIME_MAX = 40;
    private static final int MAC_AGE_TIME_MIN = 1000;
    private static final int MAC_AGE_TIME_MAX = 3600000;
    private static final int LOF_THRESHOLD_MIN = 1;
    private static final int LOF_THRESHOLD_MAX = 10;
    private static final int LOS_THRESHOLD_MIN = 1;
    private static final int LOS_THRESHOLD_MAX = 10;
    private static final int RANGE_MIN = 0;
    private static final int RANGE_MAX = 1;

    @Override
    public String getPonLinks(String target) {
        DriverHandler handler = this.handler();
        NetconfController controller = (NetconfController)handler.get(NetconfController.class);
        MastershipService mastershipService = (MastershipService)handler.get(MastershipService.class);
        DeviceId ncDeviceId = handler.data().deviceId();
        Preconditions.checkNotNull((Object)controller, (Object)"Netconf controller is null");
        String reply = null;
        if (!mastershipService.isLocalMaster(ncDeviceId)) {
            this.log.warn("Not master for {} Use {} to execute command", (Object)ncDeviceId, (Object)mastershipService.getMasterFor(ncDeviceId));
            return null;
        }
        try {
            StringBuilder request = new StringBuilder();
            request.append("<volt-ne xmlns=\"http://fujitsu.com/ns/volt/1.1\"");
            request.append(">\n");
            request.append(FujitsuVoltXmlUtility.buildStartTag(VOLT_PORTS));
            if (target != null) {
                try {
                    int pon = Integer.parseInt(target);
                    if (pon <= 0) {
                        this.log.error("Invalid integer for ponlink-id:{}", (Object)target);
                        return null;
                    }
                }
                catch (NumberFormatException e) {
                    this.log.error("Non-number input for ponlink-id:{}", (Object)target);
                    return null;
                }
                request.append(FujitsuVoltXmlUtility.buildStartTag(GPON_PONLINK_PORTS)).append(FujitsuVoltXmlUtility.buildStartTag(GPON_PONLINK_PORT)).append(FujitsuVoltXmlUtility.buildStartTag("ponlink-id", false)).append(target).append(FujitsuVoltXmlUtility.buildEndTag("ponlink-id")).append(FujitsuVoltXmlUtility.buildEndTag(GPON_PONLINK_PORT)).append(FujitsuVoltXmlUtility.buildEndTag(GPON_PONLINK_PORTS));
            } else {
                request.append(FujitsuVoltXmlUtility.buildEmptyTag(GPON_PONLINK_PORTS));
            }
            request.append(FujitsuVoltXmlUtility.buildEndTag(VOLT_PORTS));
            request.append("</volt-ne>");
            reply = ((NetconfDevice)controller.getDevicesMap().get(ncDeviceId)).getSession().get(request.toString(), "report-all");
        }
        catch (IOException e) {
            this.log.error("Cannot communicate to device {} exception {}", (Object)ncDeviceId, (Object)e);
        }
        return reply;
    }

    @Override
    public boolean setPonLink(String target) {
        DriverHandler handler = this.handler();
        NetconfController controller = (NetconfController)handler.get(NetconfController.class);
        MastershipService mastershipService = (MastershipService)handler.get(MastershipService.class);
        DeviceId ncDeviceId = handler.data().deviceId();
        Preconditions.checkNotNull((Object)controller, (Object)"Netconf controller is null");
        if (!mastershipService.isLocalMaster(ncDeviceId)) {
            this.log.warn("Not master for {} Use {} to execute command", (Object)ncDeviceId, (Object)mastershipService.getMasterFor(ncDeviceId));
            return false;
        }
        String[] data = this.checkSetInput(target);
        if (data == null) {
            this.log.error("Failed to check input: {}", (Object)target);
            return false;
        }
        boolean result = false;
        try {
            StringBuilder request = new StringBuilder();
            request.append("<volt-ne xmlns=\"http://fujitsu.com/ns/volt/1.1\"");
            request.append(">\n");
            request.append(FujitsuVoltXmlUtility.buildStartTag(VOLT_PORTS)).append(FujitsuVoltXmlUtility.buildStartTag(GPON_PONLINK_PORTS)).append(FujitsuVoltXmlUtility.buildStartTag(GPON_PONLINK_PORT)).append(FujitsuVoltXmlUtility.buildStartTag("ponlink-id", false)).append(data[0]).append(FujitsuVoltXmlUtility.buildEndTag("ponlink-id")).append(FujitsuVoltXmlUtility.buildStartTag(data[1], false)).append(data[2]).append(FujitsuVoltXmlUtility.buildEndTag(data[1])).append(FujitsuVoltXmlUtility.buildEndTag(GPON_PONLINK_PORT)).append(FujitsuVoltXmlUtility.buildEndTag(GPON_PONLINK_PORTS)).append(FujitsuVoltXmlUtility.buildEndTag(VOLT_PORTS)).append("</volt-ne>");
            result = ((NetconfDevice)controller.getDevicesMap().get(ncDeviceId)).getSession().editConfig(TargetConfig.RUNNING, null, request.toString());
        }
        catch (IOException e) {
            this.log.error("Cannot communicate to device {} exception {}", (Object)ncDeviceId, (Object)e);
        }
        return result;
    }

    private String[] checkSetInput(String target) {
        String[] data;
        block23: {
            int value;
            List<Integer> range;
            String paramValue;
            String paramName;
            block22: {
                data = target.split(":");
                paramName = data[1];
                paramValue = data[2];
                if (data.length != 3) {
                    this.log.error("Invalid number of arguments {}", (Object)data.length);
                    return null;
                }
                try {
                    int pon = Integer.parseInt(data[0]);
                    if (pon <= 0) {
                        this.log.error("Invalid integer for ponlink-id: {}", (Object)data[0]);
                        return null;
                    }
                }
                catch (NumberFormatException e) {
                    this.log.error("Non-number input for ponlink-id: {}", (Object)data[0]);
                    return null;
                }
                if (!PON_LINK_PARAMS.containsKey(paramName)) {
                    this.log.error("Unsupported parameter: {}", (Object)paramName);
                    return null;
                }
                range = PON_LINK_PARAMS.get(paramName);
                if (range != null) break block22;
                switch (paramName) {
                    case "admin-state": {
                        if (!this.validState(ADMINSTATES, paramName, paramValue)) {
                            return null;
                        }
                        break block23;
                    }
                    case "onu-discovery-mode": {
                        if (!this.validState(ONUDISCOVERYMODES, paramName, paramValue)) {
                            return null;
                        }
                        break block23;
                    }
                    case "pm-enable": {
                        if (!this.validState(PMENABLES, paramName, paramValue)) {
                            return null;
                        }
                        break block23;
                    }
                    default: {
                        if (!this.validState(LOOPBACKENABLES, paramName, paramValue)) {
                            return null;
                        }
                        break block23;
                    }
                }
            }
            try {
                value = Integer.parseInt(paramValue);
            }
            catch (NumberFormatException e) {
                this.log.error("Non-number input for Name {} : Value {}.", (Object)paramName, (Object)paramValue);
                return null;
            }
            if (value < range.get(0) || value > range.get(1)) {
                this.log.error("Out of value range for Name {} : Value {}.", (Object)paramName, (Object)paramValue);
                return null;
            }
        }
        return data;
    }

    private boolean validState(Set<String> states, String name, String value) {
        if (!states.contains(value)) {
            this.log.error("Invalid value for Name {} : Value {}.", (Object)name, (Object)value);
            return false;
        }
        return true;
    }
}

