/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.drivers.fujitsu;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import java.io.IOException;
import java.util.Set;
import org.onosproject.drivers.fujitsu.FujitsuVoltXmlUtility;
import org.onosproject.drivers.fujitsu.behaviour.VoltOnuOperConfig;
import org.onosproject.mastership.MastershipService;
import org.onosproject.net.DeviceId;
import org.onosproject.net.driver.AbstractHandlerBehaviour;
import org.onosproject.net.driver.DriverHandler;
import org.onosproject.netconf.NetconfController;
import org.onosproject.netconf.NetconfDevice;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FujitsuVoltOnuOperConfig
extends AbstractHandlerBehaviour
implements VoltOnuOperConfig {
    private final Logger log = LoggerFactory.getLogger(FujitsuVoltOnuOperConfig.class);
    private static final String ONU_REBOOT = "onu-reboot";
    private static final String ONU_ETHPORT_LOOPBACK = "onu-ethport-loopback";
    private static final String ETHPORT_ID = "ethport-id";
    private static final String LOOPBACK_MODE = "mode";
    private static final Set<String> LOOPBACKMODES = ImmutableSet.of((Object)"operate", (Object)"release");

    @Override
    public String rebootOnu(String target) {
        DriverHandler handler = this.handler();
        NetconfController controller = (NetconfController)handler.get(NetconfController.class);
        MastershipService mastershipService = (MastershipService)handler.get(MastershipService.class);
        DeviceId ncDeviceId = handler.data().deviceId();
        Preconditions.checkNotNull((Object)controller, (Object)"Netconf controller is null");
        String reply = null;
        String[] onuId = null;
        if (!mastershipService.isLocalMaster(ncDeviceId)) {
            this.log.warn("Not master for {} Use {} to execute command", (Object)ncDeviceId, (Object)mastershipService.getMasterFor(ncDeviceId));
            return null;
        }
        onuId = this.checkIdString(target, 2);
        if (onuId == null) {
            this.log.error("Invalid ONU identifier {}", (Object)target);
            return null;
        }
        try {
            StringBuilder request = new StringBuilder();
            request.append("<onu-reboot ");
            request.append("xmlns=\"http://fujitsu.com/ns/volt/1.1\">\n");
            request.append(FujitsuVoltXmlUtility.buildStartTag("ponlink-id", false)).append(onuId[0]).append(FujitsuVoltXmlUtility.buildEndTag("ponlink-id")).append(FujitsuVoltXmlUtility.buildStartTag("onu-id", false)).append(onuId[1]).append(FujitsuVoltXmlUtility.buildEndTag("onu-id")).append(FujitsuVoltXmlUtility.buildEndTag(ONU_REBOOT));
            reply = ((NetconfDevice)controller.getDevicesMap().get(ncDeviceId)).getSession().doWrappedRpc(request.toString());
        }
        catch (IOException e) {
            this.log.error("Cannot communicate to device {} exception {}", (Object)ncDeviceId, (Object)e);
        }
        return reply;
    }

    @Override
    public String loopbackEthOnu(String target) {
        DriverHandler handler = this.handler();
        NetconfController controller = (NetconfController)handler.get(NetconfController.class);
        MastershipService mastershipService = (MastershipService)handler.get(MastershipService.class);
        DeviceId ncDeviceId = handler.data().deviceId();
        Preconditions.checkNotNull((Object)controller, (Object)"Netconf controller is null");
        String reply = null;
        String[] data = null;
        String[] ethId = null;
        if (!mastershipService.isLocalMaster(ncDeviceId)) {
            this.log.warn("Not master for {} Use {} to execute command", (Object)ncDeviceId, (Object)mastershipService.getMasterFor(ncDeviceId));
            return null;
        }
        data = target.split(":");
        if (data.length > 2) {
            this.log.error("Invalid number of parameters {}", (Object)target);
            return null;
        }
        ethId = this.checkIdString(data[0], 3);
        if (ethId == null) {
            this.log.error("Invalid ETH port identifier {}", (Object)data[0]);
            return null;
        }
        if (data.length > 1 && !LOOPBACKMODES.contains(data[1])) {
            this.log.error("Unsupported parameter: {}", (Object)data[1]);
            return null;
        }
        try {
            StringBuilder request = new StringBuilder();
            request.append("<onu-ethport-loopback ");
            request.append("xmlns=\"http://fujitsu.com/ns/volt/1.1\">\n");
            request.append(FujitsuVoltXmlUtility.buildStartTag("ponlink-id", false)).append(ethId[0]).append(FujitsuVoltXmlUtility.buildEndTag("ponlink-id")).append(FujitsuVoltXmlUtility.buildStartTag("onu-id", false)).append(ethId[1]).append(FujitsuVoltXmlUtility.buildEndTag("onu-id")).append(FujitsuVoltXmlUtility.buildStartTag(ETHPORT_ID, false)).append(ethId[2]).append(FujitsuVoltXmlUtility.buildEndTag(ETHPORT_ID));
            if (data.length > 1) {
                request.append(FujitsuVoltXmlUtility.buildStartTag(LOOPBACK_MODE, false)).append(data[1]).append(FujitsuVoltXmlUtility.buildEndTag(LOOPBACK_MODE));
            }
            request.append(FujitsuVoltXmlUtility.buildEndTag(ONU_ETHPORT_LOOPBACK));
            reply = ((NetconfDevice)controller.getDevicesMap().get(ncDeviceId)).getSession().doWrappedRpc(request.toString());
        }
        catch (IOException e) {
            this.log.error("Cannot communicate to device {} exception {}", (Object)ncDeviceId, (Object)e);
        }
        return reply;
    }

    private String[] checkIdString(String target, int expected) {
        String[] id = target.split("-");
        if (id.length < 2) {
            this.log.error("Invalid number of arguments for id: {}", (Object)id.length);
            return null;
        }
        if (id.length != expected) {
            this.log.error("Invalid number of arguments for id: {}", (Object)id.length);
            return null;
        }
        try {
            int port;
            int pon = Integer.parseInt(id[0]);
            if (pon <= 0) {
                this.log.error("Invalid integer for ponlink-id: {}", (Object)id[0]);
                return null;
            }
            int onu = Integer.parseInt(id[1]);
            if (onu <= 0) {
                this.log.error("Invalid integer for onu-id: {}", (Object)id[1]);
                return null;
            }
            if (expected > 2 && (port = Integer.parseInt(id[2])) <= 0) {
                this.log.error("Invalid integer for port-id: {}", (Object)id[2]);
                return null;
            }
        }
        catch (NumberFormatException e) {
            this.log.error("Non-number input for id: {}", (Object)target);
            return null;
        }
        return id;
    }
}

