/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.drivers.fujitsu;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import java.io.IOException;
import java.util.Set;
import org.onosproject.drivers.fujitsu.FujitsuVoltXmlUtility;
import org.onosproject.drivers.fujitsu.behaviour.VoltNniLinkConfig;
import org.onosproject.mastership.MastershipService;
import org.onosproject.net.DeviceId;
import org.onosproject.net.driver.AbstractHandlerBehaviour;
import org.onosproject.net.driver.DriverHandler;
import org.onosproject.netconf.NetconfController;
import org.onosproject.netconf.NetconfDevice;
import org.onosproject.netconf.TargetConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FujitsuVoltNniLinkConfig
extends AbstractHandlerBehaviour
implements VoltNniLinkConfig {
    private final Logger log = LoggerFactory.getLogger(FujitsuVoltNniLinkConfig.class);
    private static final Set<String> NNILINKPARAMS = ImmutableSet.of((Object)"loopback-enable");
    private static final Set<String> ENABLES = ImmutableSet.of((Object)"true", (Object)"false");
    private static final String VOLT_PORTS = "volt-ports";
    private static final String ETH_NNILINK_PORTS = "eth-nnilink-ports";
    private static final String ETH_NNILINK_PORT = "eth-nnilink-port";
    private static final String NNILINK_ID = "nnilink-id";

    @Override
    public String getNniLinks(String target) {
        DriverHandler handler = this.handler();
        NetconfController controller = (NetconfController)handler.get(NetconfController.class);
        MastershipService mastershipService = (MastershipService)handler.get(MastershipService.class);
        DeviceId ncDeviceId = handler.data().deviceId();
        Preconditions.checkNotNull((Object)controller, (Object)"Netconf controller is null");
        String reply = null;
        if (!mastershipService.isLocalMaster(ncDeviceId)) {
            this.log.warn("Not master for {} Use {} to execute command", (Object)ncDeviceId, (Object)mastershipService.getMasterFor(ncDeviceId));
            return null;
        }
        try {
            StringBuilder request = new StringBuilder();
            request.append("<volt-ne xmlns=\"http://fujitsu.com/ns/volt/1.1\"").append(">\n").append(FujitsuVoltXmlUtility.buildStartTag(VOLT_PORTS));
            if (target != null) {
                try {
                    int nni = Integer.parseInt(target);
                    if (nni <= 0) {
                        this.log.error("Invalid integer for nnilink-id:{}", (Object)target);
                        return null;
                    }
                }
                catch (NumberFormatException e) {
                    this.log.error("Non-number input for nnilink-id:{}", (Object)target);
                    return null;
                }
                request.append(FujitsuVoltXmlUtility.buildStartTag(ETH_NNILINK_PORTS)).append(FujitsuVoltXmlUtility.buildStartTag(ETH_NNILINK_PORT)).append(FujitsuVoltXmlUtility.buildStartTag(NNILINK_ID, false)).append(target).append(FujitsuVoltXmlUtility.buildEndTag(NNILINK_ID)).append(FujitsuVoltXmlUtility.buildEndTag(ETH_NNILINK_PORT)).append(FujitsuVoltXmlUtility.buildEndTag(ETH_NNILINK_PORTS));
            } else {
                request.append(FujitsuVoltXmlUtility.buildEmptyTag(ETH_NNILINK_PORTS));
            }
            request.append(FujitsuVoltXmlUtility.buildEndTag(VOLT_PORTS)).append("</volt-ne>");
            reply = ((NetconfDevice)controller.getDevicesMap().get(ncDeviceId)).getSession().get(request.toString(), "report-all");
        }
        catch (IOException e) {
            this.log.error("Cannot communicate to device {} exception {}", (Object)ncDeviceId, (Object)e);
        }
        return reply;
    }

    @Override
    public boolean setNniLink(String target) {
        DriverHandler handler = this.handler();
        NetconfController controller = (NetconfController)handler.get(NetconfController.class);
        MastershipService mastershipService = (MastershipService)handler.get(MastershipService.class);
        DeviceId ncDeviceId = handler.data().deviceId();
        Preconditions.checkNotNull((Object)controller, (Object)"Netconf controller is null");
        if (!mastershipService.isLocalMaster(ncDeviceId)) {
            this.log.warn("Not master for {} Use {} to execute command", (Object)ncDeviceId, (Object)mastershipService.getMasterFor(ncDeviceId));
            return false;
        }
        String[] data = target.split(":");
        if (data.length != 3) {
            this.log.error("Invalid number of arguments {}", (Object)target);
            return false;
        }
        try {
            int nni = Integer.parseInt(data[0]);
            if (nni <= 0) {
                this.log.error("Invalid integer for nnilink-id:{}", (Object)target);
                return false;
            }
        }
        catch (NumberFormatException e) {
            this.log.error("Non-number input for nnilink-id:{}", (Object)target);
            return false;
        }
        if (!this.checkSetParam(data[1], data[2])) {
            this.log.error("Failed to check input {}", (Object)target);
            return false;
        }
        try {
            StringBuilder request = new StringBuilder();
            request.append("<volt-ne xmlns=\"http://fujitsu.com/ns/volt/1.1\"").append(">\n").append(FujitsuVoltXmlUtility.buildStartTag(VOLT_PORTS)).append(FujitsuVoltXmlUtility.buildStartTag(ETH_NNILINK_PORTS)).append(FujitsuVoltXmlUtility.buildStartTag(ETH_NNILINK_PORT)).append(FujitsuVoltXmlUtility.buildStartTag(NNILINK_ID, false)).append(data[0]).append(FujitsuVoltXmlUtility.buildEndTag(NNILINK_ID)).append(FujitsuVoltXmlUtility.buildStartTag(data[1], false)).append(data[2]).append(FujitsuVoltXmlUtility.buildEndTag(data[1])).append(FujitsuVoltXmlUtility.buildEndTag(ETH_NNILINK_PORT)).append(FujitsuVoltXmlUtility.buildEndTag(ETH_NNILINK_PORTS)).append(FujitsuVoltXmlUtility.buildEndTag(VOLT_PORTS)).append("</volt-ne>");
            ((NetconfDevice)controller.getDevicesMap().get(ncDeviceId)).getSession().editConfig(TargetConfig.RUNNING, null, request.toString());
        }
        catch (IOException e) {
            this.log.error("Cannot communicate to device {} exception {}", (Object)ncDeviceId, (Object)e);
            return false;
        }
        return true;
    }

    private boolean checkSetParam(String name, String value) {
        if (!NNILINKPARAMS.contains(name)) {
            this.log.error("Unsupported parameter: {}", (Object)name);
            return false;
        }
        switch (name) {
            default: 
        }
        if (!ENABLES.contains(value)) {
            this.log.error("Invalid value for Name {} : Value {}.", (Object)name, (Object)value);
            return false;
        }
        return true;
    }
}

