/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.drivers.fujitsu;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import java.io.IOException;
import java.util.Set;
import org.onosproject.drivers.fujitsu.FujitsuVoltXmlUtility;
import org.onosproject.drivers.fujitsu.behaviour.VoltAlertConfig;
import org.onosproject.mastership.MastershipService;
import org.onosproject.net.DeviceId;
import org.onosproject.net.driver.AbstractHandlerBehaviour;
import org.onosproject.net.driver.DriverHandler;
import org.onosproject.netconf.NetconfController;
import org.onosproject.netconf.NetconfDevice;
import org.onosproject.netconf.TargetConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FujitsuVoltAlertConfig
extends AbstractHandlerBehaviour
implements VoltAlertConfig {
    private final Logger log = LoggerFactory.getLogger(FujitsuVoltAlertConfig.class);
    private static final String VOLT_ALERTS = "volt-alerts";
    private static final String ALERT_FILTER = "alert-filter";
    private static final String NOTIFY_ALERT = "notify-alert";
    private static final Set<String> SEVERITYLEVELS = ImmutableSet.of((Object)"none", (Object)"info", (Object)"minor", (Object)"major", (Object)"critical");
    private static final String DISABLE = "disable";

    @Override
    public String getAlertFilter() {
        DriverHandler handler = this.handler();
        NetconfController controller = (NetconfController)handler.get(NetconfController.class);
        MastershipService mastershipService = (MastershipService)handler.get(MastershipService.class);
        DeviceId ncDeviceId = handler.data().deviceId();
        Preconditions.checkNotNull((Object)controller, (Object)"Netconf controller is null");
        String reply = null;
        if (!mastershipService.isLocalMaster(ncDeviceId)) {
            this.log.warn("Not master for {} Use {} to execute command", (Object)ncDeviceId, (Object)mastershipService.getMasterFor(ncDeviceId));
            return null;
        }
        try {
            StringBuilder request = new StringBuilder();
            request.append("<volt-ne xmlns=\"http://fujitsu.com/ns/volt/1.1\"");
            request.append(">\n");
            request.append(FujitsuVoltXmlUtility.buildStartTag(VOLT_ALERTS)).append(FujitsuVoltXmlUtility.buildEmptyTag(ALERT_FILTER)).append(FujitsuVoltXmlUtility.buildEndTag(VOLT_ALERTS)).append("</volt-ne>");
            reply = ((NetconfDevice)controller.getDevicesMap().get(ncDeviceId)).getSession().get(request.toString(), "report-all");
        }
        catch (IOException e) {
            this.log.error("Cannot communicate to device {} exception {}", (Object)ncDeviceId, (Object)e);
        }
        return reply;
    }

    @Override
    public boolean setAlertFilter(String severity) {
        DriverHandler handler = this.handler();
        NetconfController controller = (NetconfController)handler.get(NetconfController.class);
        MastershipService mastershipService = (MastershipService)handler.get(MastershipService.class);
        DeviceId ncDeviceId = handler.data().deviceId();
        Preconditions.checkNotNull((Object)controller, (Object)"Netconf controller is null");
        if (!mastershipService.isLocalMaster(ncDeviceId)) {
            this.log.warn("Not master for {} Use {} to execute command", (Object)ncDeviceId, (Object)mastershipService.getMasterFor(ncDeviceId));
            return false;
        }
        if (!SEVERITYLEVELS.contains(severity)) {
            this.log.error("Invalid severity level: {}", (Object)severity);
            return false;
        }
        try {
            StringBuilder request = new StringBuilder();
            request.append("<volt-ne xmlns=\"http://fujitsu.com/ns/volt/1.1\"");
            request.append(">\n");
            request.append(FujitsuVoltXmlUtility.buildStartTag(VOLT_ALERTS)).append(FujitsuVoltXmlUtility.buildStartTag(ALERT_FILTER, false)).append(severity).append(FujitsuVoltXmlUtility.buildEndTag(ALERT_FILTER)).append(FujitsuVoltXmlUtility.buildEndTag(VOLT_ALERTS)).append("</volt-ne>");
            ((NetconfDevice)controller.getDevicesMap().get(ncDeviceId)).getSession().editConfig(TargetConfig.RUNNING, null, request.toString());
        }
        catch (IOException e) {
            this.log.error("Cannot communicate to device {} exception {}", (Object)ncDeviceId, (Object)e);
            return false;
        }
        return true;
    }

    @Override
    public boolean subscribe(String mode) {
        DriverHandler handler = this.handler();
        NetconfController controller = (NetconfController)handler.get(NetconfController.class);
        MastershipService mastershipService = (MastershipService)handler.get(MastershipService.class);
        DeviceId ncDeviceId = handler.data().deviceId();
        Preconditions.checkNotNull((Object)controller, (Object)"Netconf controller is null");
        if (!mastershipService.isLocalMaster(ncDeviceId)) {
            this.log.warn("Not master for {} Use {} to execute command", (Object)ncDeviceId, (Object)mastershipService.getMasterFor(ncDeviceId));
            return false;
        }
        if (mode != null && !DISABLE.equals(mode)) {
            this.log.error("Invalid mode: {}", (Object)mode);
            return false;
        }
        try {
            if (mode != null) {
                ((NetconfDevice)controller.getDevicesMap().get(ncDeviceId)).getSession().endSubscription();
            } else {
                StringBuilder request = new StringBuilder();
                request.append("<notify-alert ");
                request.append("xmlns=\"http://fujitsu.com/ns/volt/1.1\"/>");
                ((NetconfDevice)controller.getDevicesMap().get(ncDeviceId)).getSession().startSubscription(request.toString());
            }
        }
        catch (IOException e) {
            this.log.error("Cannot communicate to device {} exception {}", (Object)ncDeviceId, (Object)e);
            return false;
        }
        return true;
    }
}

