/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.tetopology.management.impl;

import com.google.common.base.MoreObjects;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.felix.scr.annotations.Activate;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Deactivate;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.ReferenceCardinality;
import org.apache.felix.scr.annotations.Service;
import org.onlab.packet.Ip4Address;
import org.onlab.util.Tools;
import org.onosproject.app.ApplicationException;
import org.onosproject.core.ApplicationId;
import org.onosproject.core.CoreService;
import org.onosproject.event.Event;
import org.onosproject.event.EventListener;
import org.onosproject.event.EventSink;
import org.onosproject.incubator.net.config.basics.ConfigException;
import org.onosproject.net.DeviceId;
import org.onosproject.net.config.ConfigFactory;
import org.onosproject.net.config.NetworkConfigEvent;
import org.onosproject.net.config.NetworkConfigListener;
import org.onosproject.net.config.NetworkConfigRegistry;
import org.onosproject.net.config.basics.SubjectFactories;
import org.onosproject.net.device.DeviceProviderRegistry;
import org.onosproject.net.device.DeviceService;
import org.onosproject.net.link.LinkProviderRegistry;
import org.onosproject.net.link.LinkService;
import org.onosproject.net.provider.AbstractListenerProviderRegistry;
import org.onosproject.net.provider.AbstractProviderService;
import org.onosproject.net.provider.Provider;
import org.onosproject.tetopology.management.api.CommonTopologyData;
import org.onosproject.tetopology.management.api.DefaultNetwork;
import org.onosproject.tetopology.management.api.DefaultNetworks;
import org.onosproject.tetopology.management.api.DefaultTeTopologies;
import org.onosproject.tetopology.management.api.DefaultTeTopology;
import org.onosproject.tetopology.management.api.KeyId;
import org.onosproject.tetopology.management.api.Network;
import org.onosproject.tetopology.management.api.Networks;
import org.onosproject.tetopology.management.api.OptimizationType;
import org.onosproject.tetopology.management.api.TeTopologies;
import org.onosproject.tetopology.management.api.TeTopology;
import org.onosproject.tetopology.management.api.TeTopologyEvent;
import org.onosproject.tetopology.management.api.TeTopologyEventSubject;
import org.onosproject.tetopology.management.api.TeTopologyKey;
import org.onosproject.tetopology.management.api.TeTopologyListener;
import org.onosproject.tetopology.management.api.TeTopologyProvider;
import org.onosproject.tetopology.management.api.TeTopologyProviderRegistry;
import org.onosproject.tetopology.management.api.TeTopologyProviderService;
import org.onosproject.tetopology.management.api.TeTopologyService;
import org.onosproject.tetopology.management.api.link.CommonLinkData;
import org.onosproject.tetopology.management.api.link.DefaultTeLink;
import org.onosproject.tetopology.management.api.link.ExternalLink;
import org.onosproject.tetopology.management.api.link.LinkBandwidth;
import org.onosproject.tetopology.management.api.link.NetworkLink;
import org.onosproject.tetopology.management.api.link.NetworkLinkEventSubject;
import org.onosproject.tetopology.management.api.link.NetworkLinkKey;
import org.onosproject.tetopology.management.api.link.TeLink;
import org.onosproject.tetopology.management.api.link.TeLinkEventSubject;
import org.onosproject.tetopology.management.api.link.TeLinkTpGlobalKey;
import org.onosproject.tetopology.management.api.link.TeLinkTpKey;
import org.onosproject.tetopology.management.api.link.TePathAttributes;
import org.onosproject.tetopology.management.api.link.UnderlayPath;
import org.onosproject.tetopology.management.api.node.CommonNodeData;
import org.onosproject.tetopology.management.api.node.DefaultTeNode;
import org.onosproject.tetopology.management.api.node.DefaultTunnelTerminationPoint;
import org.onosproject.tetopology.management.api.node.NetworkNode;
import org.onosproject.tetopology.management.api.node.NetworkNodeEventSubject;
import org.onosproject.tetopology.management.api.node.NetworkNodeKey;
import org.onosproject.tetopology.management.api.node.TeNode;
import org.onosproject.tetopology.management.api.node.TeNodeEventSubject;
import org.onosproject.tetopology.management.api.node.TeNodeKey;
import org.onosproject.tetopology.management.api.node.TerminationPoint;
import org.onosproject.tetopology.management.api.node.TerminationPointKey;
import org.onosproject.tetopology.management.api.node.TtpKey;
import org.onosproject.tetopology.management.api.node.TunnelTerminationPoint;
import org.onosproject.tetopology.management.impl.TeMgrUtil;
import org.onosproject.tetopology.management.impl.TeTopologyConfig;
import org.onosproject.tetopology.management.impl.TeTopologyMapEvent;
import org.onosproject.tetopology.management.impl.TeTopologyStore;
import org.onosproject.tetopology.management.impl.TeTopologyStoreDelegate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(immediate=true)
@Service
public class TeTopologyManager
extends AbstractListenerProviderRegistry<TeTopologyEvent, TeTopologyListener, TeTopologyProvider, TeTopologyProviderService>
implements TeTopologyService,
TeTopologyProviderRegistry {
    private static final String APP_NAME = "org.onosproject.tetopology";
    private static final long DEFAULT_PROVIDER_ID = 77777L;
    private static final long DEFAULT_CLIENT_ID = 0L;
    private long providerId = 77777L;
    private static final int MAX_THREADS = 1;
    private static final Ip4Address DEFAULT_TENODE_ID_START = Ip4Address.valueOf((String)"10.10.10.10");
    private static final Ip4Address DEFAULT_TENODE_ID_END = Ip4Address.valueOf((String)"250.250.250.250");
    private Ip4Address teNodeIpStart = DEFAULT_TENODE_ID_START;
    private Ip4Address teNodeIpEnd = DEFAULT_TENODE_ID_END;
    private long nextTeNodeId = this.teNodeIpStart.toInt();
    private boolean mdsc = true;
    private static final String MDSC_MODE = "true";
    private final Logger log = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected CoreService coreService;
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected NetworkConfigRegistry cfgService;
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected DeviceService deviceService;
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected LinkService linkService;
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected DeviceProviderRegistry deviceProviderRegistry;
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected LinkProviderRegistry linkProviderRegistry;
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    public TeTopologyStore store;
    private TeTopologyStoreDelegate delegate = arg_0 -> ((TeTopologyManager)this).post(arg_0);
    private final ConfigFactory<ApplicationId, TeTopologyConfig> factory = new ConfigFactory<ApplicationId, TeTopologyConfig>(SubjectFactories.APP_SUBJECT_FACTORY, TeTopologyConfig.class, "teTopologyCfg", false){

        public TeTopologyConfig createConfig() {
            return new TeTopologyConfig();
        }
    };
    private final NetworkConfigListener cfgLister = new InternalConfigListener();
    private ApplicationId appId;
    private TeTopology mergedTopology = null;
    private TeTopologyKey mergedTopologyKey;
    private Network mergedNetwork = null;
    private Map<TeNodeKey, Long> sourceNewTeNodeIdMap = Maps.newHashMap();
    private Map<Long, LinkKeyPair> externalLinkMap = Maps.newHashMap();
    private ExecutorService executor;

    public void activateBasics() {
        this.store.setDelegate(this.delegate);
        this.store.setProviderId(this.providerId);
        this.eventDispatcher.addSink(TeTopologyEvent.class, (EventSink)this.listenerRegistry);
    }

    public void deactivateBasics() {
        this.store.unsetDelegate(this.delegate);
        this.eventDispatcher.removeSink(TeTopologyEvent.class);
    }

    @Activate
    public void activate() {
        this.activateBasics();
        this.appId = this.coreService.registerApplication(APP_NAME);
        this.cfgService.registerConfigFactory(this.factory);
        this.executor = Executors.newFixedThreadPool(1, Tools.groupedThreads((String)"onos/tetopology", (String)"build-%d", (Logger)this.log));
        this.cfgService.addListener((EventListener)this.cfgLister);
        this.executor.execute(new TopologyMergerTask());
        this.log.info("Started");
    }

    @Deactivate
    public void deactivate() {
        this.deactivateBasics();
        this.externalLinkMap.clear();
        this.cfgService.removeListener((EventListener)this.cfgLister);
        this.cfgService.unregisterConfigFactory(this.factory);
        this.executor.shutdownNow();
        this.executor = null;
        this.log.info("Stopped");
    }

    protected TeTopologyProviderService createProviderService(TeTopologyProvider provider) {
        return new InternalTopologyProviderService(provider);
    }

    private boolean isCustomizedLearnedTopology(TeTopologyKey key) {
        return this.store.teTopology(key).flags().get(3) && this.store.teTopology(key).flags().get(1);
    }

    private void removeSourceTeNode(Map<Long, TeNode> teNodes, TeNodeKey srcNodeKey, boolean postEvent) {
        Long mergedTeNodeId = this.sourceNewTeNodeIdMap.remove(srcNodeKey);
        if (mergedTeNodeId == null) {
            return;
        }
        if (teNodes.remove(mergedTeNodeId) != null && postEvent) {
            TeNodeKey nodeKey = new TeNodeKey(this.mergedTopologyKey, mergedTeNodeId.longValue());
            this.post((Event)new TeTopologyEvent(TeTopologyEvent.Type.TE_NODE_REMOVED, (TeTopologyEventSubject)new TeNodeEventSubject(nodeKey, null)));
            this.post((Event)new TeTopologyEvent(TeTopologyEvent.Type.NODE_REMOVED, (TeTopologyEventSubject)new NetworkNodeEventSubject(TeMgrUtil.networkNodeKey(nodeKey), null)));
        }
    }

    private void updateSourceTeNode(Map<Long, TeNode> teNodes, TeTopologyKey srcTopoKey, TeNode srcNode, boolean postEvent) {
        TeNodeKey sourceTeNodeId = new TeNodeKey(srcTopoKey, srcNode.teNodeId());
        Long mergedTeNodeId = this.sourceNewTeNodeIdMap.get(sourceTeNodeId);
        boolean addNode = false;
        if (mergedTeNodeId == null) {
            addNode = true;
            mergedTeNodeId = this.nextTeNodeId;
            ++this.nextTeNodeId;
            if (this.nextTeNodeId >= (long)this.teNodeIpEnd.toInt()) {
                this.nextTeNodeId = this.teNodeIpStart.toInt();
                this.log.warn("TE node Id is wrapped back");
            }
            this.sourceNewTeNodeIdMap.put(sourceTeNodeId, mergedTeNodeId);
        }
        TeTopologyKey underlayTopologyId = null;
        TeNodeKey supportTeNodeId = null;
        CommonNodeData common = new CommonNodeData(srcNode.name(), srcNode.adminStatus(), srcNode.opStatus(), srcNode.flags());
        Map connMatrices = srcNode.connectivityMatrices();
        List teLinkIds = srcNode.teLinkIds();
        HashMap ttps = null;
        if (MapUtils.isNotEmpty((Map)srcNode.tunnelTerminationPoints())) {
            ttps = Maps.newHashMap();
            for (Map.Entry entry : srcNode.tunnelTerminationPoints().entrySet()) {
                TunnelTerminationPoint ttp = (TunnelTerminationPoint)entry.getValue();
                ttps.put(entry.getKey(), new DefaultTunnelTerminationPoint(ttp.ttpId(), ttp.switchingLayer(), ttp.encodingLayer(), ttp.flags(), ttp.interLayerLockList(), ttp.localLinkConnectivityList(), ttp.availAdaptBandwidth(), null));
            }
        }
        List teTpIds = srcNode.teTerminationPointIds();
        DefaultTeNode newNode = new DefaultTeNode(mergedTeNodeId.longValue(), underlayTopologyId, supportTeNodeId, sourceTeNodeId, common, connMatrices, teLinkIds, (Map)ttps, teTpIds);
        teNodes.put(mergedTeNodeId, (TeNode)newNode);
        if (postEvent) {
            TeNodeKey globalKey = new TeNodeKey(this.mergedTopologyKey, mergedTeNodeId.longValue());
            this.post((Event)new TeTopologyEvent(addNode ? TeTopologyEvent.Type.TE_NODE_ADDED : TeTopologyEvent.Type.TE_NODE_UPDATED, (TeTopologyEventSubject)new TeNodeEventSubject(globalKey, (TeNode)newNode)));
            this.post((Event)new TeTopologyEvent(addNode ? TeTopologyEvent.Type.NODE_ADDED : TeTopologyEvent.Type.NODE_UPDATED, (TeTopologyEventSubject)new NetworkNodeEventSubject(TeMgrUtil.networkNodeKey(globalKey), TeMgrUtil.nodeBuilder(KeyId.keyId((String)Ip4Address.valueOf((int)((int)newNode.teNodeId())).toString()), (TeNode)newNode))));
        }
    }

    private void mergeNodes(Map<Long, TeNode> nodes, TeTopology topology) {
        if (!MapUtils.isEmpty((Map)topology.teNodes())) {
            for (Map.Entry entry : topology.teNodes().entrySet()) {
                this.updateSourceTeNode(nodes, topology.teTopologyId(), (TeNode)entry.getValue(), this.mergedTopology != null);
            }
        }
    }

    private TeLink updateTeLink(TeLinkTpKey newKey, TeLinkTpKey peerTeLinkKey, TeTopologyKey underlayTopologyId, TeLinkTpGlobalKey supportTeLinkId, TeLinkTpGlobalKey sourceTeLinkId, ExternalLink externalLink, TeLink exLink) {
        UnderlayPath underlayPath = null;
        if (underlayTopologyId != null && underlayTopologyId.equals((Object)exLink.underlayTeTopologyId())) {
            underlayPath = new UnderlayPath(exLink.primaryPath(), exLink.backupPaths(), exLink.tunnelProtectionType(), exLink.sourceTtpId(), exLink.destinationTtpId(), exLink.teTunnelId());
        }
        TePathAttributes teAttributes = new TePathAttributes(exLink.cost(), exLink.delay(), exLink.srlgs());
        LinkBandwidth bandwidth = new LinkBandwidth(exLink.maxBandwidth(), exLink.availBandwidth(), exLink.maxAvailLspBandwidth(), exLink.minAvailLspBandwidth(), exLink.oduResource());
        BitSet flags = exLink.flags();
        if (peerTeLinkKey != null && externalLink != null && externalLink.plugId() != null) {
            flags.clear(3);
        } else if (peerTeLinkKey == null && externalLink != null && externalLink.plugId() != null) {
            flags.set(3);
        }
        CommonLinkData common = new CommonLinkData(exLink.adminStatus(), exLink.opStatus(), flags, exLink.switchingLayer(), exLink.encodingLayer(), externalLink, underlayPath, teAttributes, exLink.administrativeGroup(), exLink.interLayerLocks(), bandwidth);
        return new DefaultTeLink(newKey, peerTeLinkKey, underlayTopologyId, supportTeLinkId, sourceTeLinkId, common);
    }

    private void removeSourceTeLink(Map<TeLinkTpKey, TeLink> teLinks, TeLinkTpGlobalKey teLinkKey, boolean postEvent) {
        TeLinkTpKey peerTeLinkKey;
        TeNodeKey sourceTeNodeKey = teLinkKey.teNodeKey();
        Long newTeNodeId = this.sourceNewTeNodeIdMap.get(sourceTeNodeKey);
        if (newTeNodeId == null) {
            return;
        }
        TeLinkTpKey newLinkKey = new TeLinkTpKey(newTeNodeId.longValue(), teLinkKey.teLinkTpId());
        TeLink teLink = teLinks.remove(newLinkKey);
        if (teLink == null) {
            return;
        }
        if (postEvent) {
            TeLinkTpGlobalKey globalKey = new TeLinkTpGlobalKey(this.mergedTopologyKey, newLinkKey);
            this.post((Event)new TeTopologyEvent(TeTopologyEvent.Type.TE_LINK_REMOVED, (TeTopologyEventSubject)new TeLinkEventSubject(globalKey, null)));
            this.post((Event)new TeTopologyEvent(TeTopologyEvent.Type.LINK_REMOVED, (TeTopologyEventSubject)new NetworkLinkEventSubject(TeMgrUtil.networkLinkKey(globalKey), null)));
        }
        if (teLink.externalLink() != null && teLink.externalLink().plugId() != null) {
            LinkKeyPair pair = this.externalLinkMap.get(teLink.externalLink().plugId());
            if (pair.isFirstKey(newLinkKey)) {
                pair.setFirstKey(null);
            } else if (pair.isSecondKey(newLinkKey)) {
                pair.setSecondKey(null);
            }
            if (pair.isEmpty()) {
                this.externalLinkMap.remove(teLink.externalLink().plugId());
            }
        }
        if ((peerTeLinkKey = teLink.peerTeLinkKey()) != null) {
            TeLink peerLink = teLinks.get(peerTeLinkKey);
            if (peerLink == null || peerLink.peerTeLinkKey() == null) {
                return;
            }
            TeLink newPeerLink = this.updateTeLink(peerTeLinkKey, null, peerLink.underlayTeTopologyId(), peerLink.supportingTeLinkId(), peerLink.sourceTeLinkId(), peerLink.externalLink(), peerLink);
            teLinks.put(peerTeLinkKey, newPeerLink);
            if (postEvent) {
                TeLinkTpGlobalKey globalKey = new TeLinkTpGlobalKey(this.mergedTopologyKey, peerTeLinkKey);
                this.post((Event)new TeTopologyEvent(TeTopologyEvent.Type.TE_LINK_UPDATED, (TeTopologyEventSubject)new TeLinkEventSubject(globalKey, newPeerLink)));
                this.post((Event)new TeTopologyEvent(TeTopologyEvent.Type.LINK_UPDATED, (TeTopologyEventSubject)new NetworkLinkEventSubject(TeMgrUtil.networkLinkKey(globalKey), TeMgrUtil.linkBuilder(TeMgrUtil.toNetworkLinkId(peerTeLinkKey), newPeerLink))));
            }
        }
    }

    private void updateSourceTeLink(Map<TeLinkTpKey, TeLink> teLinks, TeTopologyKey srcTopoKey, TeLink srcLink, boolean postEvent) {
        TeNodeKey sourceTeNodeId = new TeNodeKey(srcTopoKey, srcLink.teLinkKey().teNodeId());
        TeLinkTpKey newKey = new TeLinkTpKey(this.sourceNewTeNodeIdMap.get(sourceTeNodeId).longValue(), srcLink.teLinkKey().teLinkTpId());
        TeLinkTpKey peerTeLinkKey = null;
        if (srcLink.peerTeLinkKey() != null) {
            TeNodeKey sourcePeerNode = new TeNodeKey(srcTopoKey, srcLink.peerTeLinkKey().teNodeId());
            peerTeLinkKey = new TeLinkTpKey(this.sourceNewTeNodeIdMap.get(sourcePeerNode).longValue(), srcLink.peerTeLinkKey().teLinkTpId());
        }
        if (srcLink.externalLink() != null && srcLink.externalLink().plugId() != null) {
            LinkKeyPair pair = this.externalLinkMap.get(srcLink.externalLink().plugId());
            if (pair == null) {
                this.externalLinkMap.put(srcLink.externalLink().plugId(), new LinkKeyPair(newKey));
            } else {
                TeLink peerLink;
                if (newKey.equals((Object)pair.firstKey())) {
                    peerTeLinkKey = pair.secondKey();
                } else if (newKey.equals((Object)pair.secondKey())) {
                    peerTeLinkKey = pair.firstKey();
                } else if (pair.firstKey() == null) {
                    peerTeLinkKey = pair.secondKey();
                    pair.setFirstKey(newKey);
                } else if (pair.secondKey() == null) {
                    peerTeLinkKey = pair.firstKey();
                    pair.setSecondKey(newKey);
                }
                if (!(peerTeLinkKey == null || (peerLink = teLinks.get(peerTeLinkKey)) == null || peerLink.peerTeLinkKey() != null && peerLink.peerTeLinkKey().equals((Object)newKey))) {
                    TeLink newPeerLink = this.updateTeLink(peerTeLinkKey, newKey, peerLink.underlayTeTopologyId(), peerLink.supportingTeLinkId(), peerLink.sourceTeLinkId(), peerLink.externalLink(), peerLink);
                    teLinks.put(peerTeLinkKey, newPeerLink);
                    if (postEvent) {
                        TeLinkTpGlobalKey globalKey = new TeLinkTpGlobalKey(this.mergedTopologyKey, peerTeLinkKey);
                        this.post((Event)new TeTopologyEvent(TeTopologyEvent.Type.TE_LINK_UPDATED, (TeTopologyEventSubject)new TeLinkEventSubject(globalKey, newPeerLink)));
                        this.post((Event)new TeTopologyEvent(TeTopologyEvent.Type.LINK_UPDATED, (TeTopologyEventSubject)new NetworkLinkEventSubject(TeMgrUtil.networkLinkKey(globalKey), TeMgrUtil.linkBuilder(TeMgrUtil.toNetworkLinkId(peerTeLinkKey), newPeerLink))));
                    }
                }
            }
        }
        TeTopologyKey underlayTopologyId = null;
        TeLinkTpGlobalKey supportTeLinkId = null;
        TeLinkTpGlobalKey sourceTeLinkId = new TeLinkTpGlobalKey(srcTopoKey, srcLink.teLinkKey());
        TeLink updatedLink = this.updateTeLink(newKey, peerTeLinkKey, underlayTopologyId, supportTeLinkId, sourceTeLinkId, srcLink.externalLink(), srcLink);
        TeLinkTpGlobalKey newGlobalKey = new TeLinkTpGlobalKey(this.mergedTopologyKey, newKey);
        boolean newLink = teLinks.get(newKey) == null;
        teLinks.put(newKey, updatedLink);
        if (postEvent) {
            this.post((Event)new TeTopologyEvent(newLink ? TeTopologyEvent.Type.TE_LINK_ADDED : TeTopologyEvent.Type.TE_LINK_UPDATED, (TeTopologyEventSubject)new TeLinkEventSubject(newGlobalKey, updatedLink)));
            this.post((Event)new TeTopologyEvent(newLink ? TeTopologyEvent.Type.LINK_ADDED : TeTopologyEvent.Type.LINK_UPDATED, (TeTopologyEventSubject)new NetworkLinkEventSubject(TeMgrUtil.networkLinkKey(newGlobalKey), TeMgrUtil.linkBuilder(TeMgrUtil.toNetworkLinkId(updatedLink.teLinkKey()), updatedLink))));
        }
    }

    private void mergeLinks(Map<TeLinkTpKey, TeLink> teLinks, TeTopology topology) {
        if (!MapUtils.isEmpty((Map)topology.teLinks())) {
            for (Map.Entry entry : topology.teLinks().entrySet()) {
                TeLink srcLink = (TeLink)entry.getValue();
                this.updateSourceTeLink(teLinks, topology.teTopologyId(), srcLink, this.mergedTopology != null);
            }
        }
    }

    private void updateMergedTopology(Map<Long, TeNode> teNodes, Map<TeLinkTpKey, TeLink> teLinks) {
        boolean newTopology = this.mergedTopology == null;
        BitSet flags = newTopology ? new BitSet(16) : this.mergedTopology.flags();
        flags.set(2);
        CommonTopologyData commonData = new CommonTopologyData(newTopology ? TeMgrUtil.toNetworkId(this.mergedTopologyKey) : this.mergedTopology.networkId(), OptimizationType.NOT_OPTIMIZED, flags, DeviceId.deviceId((String)"localHost"));
        this.mergedTopology = new DefaultTeTopology(this.mergedTopologyKey, teNodes, teLinks, Long.toString(this.mergedTopologyKey.topologyId()), commonData);
        this.mergedNetwork = TeMgrUtil.networkBuilder(this.mergedTopology);
        this.log.info("Nodes# {}, Links# {}", (Object)this.mergedTopology.teNodes().size(), (Object)this.mergedTopology.teLinks().size());
    }

    private void mergeTopology(TeTopology topology) {
        boolean newTopology = this.mergedTopology == null;
        this.mergedTopologyKey = newTopology ? new TeTopologyKey(this.providerId, 0L, this.store.nextTeTopologyId()) : this.mergedTopology.teTopologyId();
        HashMap teNodes = newTopology || this.mergedTopology.teNodes() == null ? Maps.newHashMap() : Maps.newHashMap((Map)this.mergedTopology.teNodes());
        this.mergeNodes(teNodes, topology);
        HashMap teLinks = newTopology || this.mergedTopology.teLinks() == null ? Maps.newHashMap() : Maps.newHashMap((Map)this.mergedTopology.teLinks());
        this.mergeLinks(teLinks, topology);
        this.updateMergedTopology(teNodes, teLinks);
        this.log.debug("mergedTopology {}", (Object)this.mergedTopology);
        if (newTopology) {
            this.post((Event)new TeTopologyEvent(TeTopologyEvent.Type.TE_TOPOLOGY_ADDED, (TeTopologyEventSubject)this.mergedTopology));
            this.post((Event)new TeTopologyEvent(TeTopologyEvent.Type.NETWORK_ADDED, (TeTopologyEventSubject)this.mergedNetwork));
        }
    }

    private TeTopologyKey newTeTopologyKey(TeTopology teTopology) {
        TeTopologyKey key = teTopology.teTopologyId();
        if (key == null || teTopology.teTopologyIdStringValue() == null) {
            this.log.error("Ignoring the non-TE topology");
            throw new ApplicationException("Missing TE topology ID");
        }
        long idValue = key.topologyId();
        if (idValue == 0L && teTopology.teTopologyIdStringValue() != null) {
            try {
                idValue = Long.parseLong(teTopology.teTopologyIdStringValue());
            }
            catch (NumberFormatException e) {
                idValue = this.store.nextTeTopologyId();
            }
            return new TeTopologyKey(key.providerId(), key.clientId(), idValue);
        }
        return null;
    }

    public TeTopologies teTopologies() {
        HashMap map = MapUtils.isNotEmpty((Map)this.store.teTopologies().teTopologies()) ? Maps.newHashMap((Map)this.store.teTopologies().teTopologies()) : Maps.newHashMap();
        if (this.mergedTopology != null) {
            map.put(this.mergedTopologyKey, this.mergedTopology);
        }
        return new DefaultTeTopologies(this.store.teTopologies().name(), (Map)map);
    }

    public TeTopology teTopology(TeTopologyKey topologyId) {
        if (this.mergedTopology != null && topologyId != null && topologyId.equals((Object)this.mergedTopologyKey)) {
            return this.mergedTopology;
        }
        return this.store.teTopology(topologyId);
    }

    public TeTopology mergedTopology() {
        return this.mergedTopology;
    }

    public void updateTeTopology(TeTopology teTopology) {
        TeTopologyKey newKey = null;
        try {
            newKey = this.newTeTopologyKey(teTopology);
        }
        catch (ApplicationException e) {
            this.log.error("Ignoring the non-TE topology");
            return;
        }
        BitSet flags = teTopology.flags();
        if (flags == null || !flags.get(3) && !flags.get(2)) {
            this.log.error("TE topology flags {} are not set properly", (Object)flags);
            return;
        }
        if (newKey != null) {
            DefaultTeTopology newTopology = new DefaultTeTopology(newKey == null ? teTopology.teTopologyId() : newKey, teTopology.teNodes(), teTopology.teLinks(), teTopology.teTopologyIdStringValue(), new CommonTopologyData(teTopology));
            this.store.updateTeTopology((TeTopology)newTopology);
        } else {
            this.store.updateTeTopology(teTopology);
        }
    }

    public void removeTeTopology(TeTopologyKey topologyId) {
        this.store.removeTeTopology(topologyId);
    }

    public Networks networks() {
        ArrayList networks = CollectionUtils.isNotEmpty(this.store.networks()) ? Lists.newArrayList(this.store.networks()) : Lists.newArrayList();
        if (this.mergedNetwork != null) {
            networks.add(this.mergedNetwork);
        }
        return new DefaultNetworks((List)networks);
    }

    public Network network(KeyId networkId) {
        if (this.mergedNetwork != null && this.mergedNetwork.networkId().equals((Object)networkId)) {
            return this.mergedNetwork;
        }
        return this.store.network(networkId);
    }

    public void updateNetwork(Network network) {
    }

    public void removeNetwork(KeyId networkId) {
    }

    public TeNode teNode(TeNodeKey nodeId) {
        return nodeId.teTopologyKey().equals((Object)this.mergedTopologyKey) ? this.mergedTopology.teNode(nodeId.teNodeId()) : this.store.teNode(nodeId);
    }

    public TeLink teLink(TeLinkTpGlobalKey linkId) {
        return linkId.teTopologyKey().equals((Object)this.mergedTopologyKey) ? this.mergedTopology.teLink(linkId.teLinkTpKey()) : this.store.teLink(linkId);
    }

    public TunnelTerminationPoint tunnelTerminationPoint(TtpKey ttpId) {
        return ttpId.teTopologyKey().equals((Object)this.mergedTopologyKey) ? this.mergedTopology.teNode(ttpId.teNodeId()).tunnelTerminationPoint(ttpId.ttpId()) : this.store.tunnelTerminationPoint(ttpId);
    }

    public KeyId networkId(TeTopologyKey teTopologyKey) {
        return teTopologyKey.equals((Object)this.mergedTopologyKey) ? this.mergedNetwork.networkId() : this.store.networkId(teTopologyKey);
    }

    public NetworkNodeKey nodeKey(TeNodeKey teNodeKey) {
        return teNodeKey.teTopologyKey().equals((Object)this.mergedTopologyKey) ? TeMgrUtil.networkNodeKey(teNodeKey) : this.store.nodeKey(teNodeKey);
    }

    public NetworkLinkKey linkKey(TeLinkTpGlobalKey teLinkKey) {
        return teLinkKey.teTopologyKey().equals((Object)this.mergedTopologyKey) ? TeMgrUtil.networkLinkKey(teLinkKey) : this.store.linkKey(teLinkKey);
    }

    public TerminationPointKey terminationPointKey(TeLinkTpGlobalKey teTpKey) {
        return teTpKey.teTopologyKey().equals((Object)this.mergedTopologyKey) ? new TerminationPointKey(TeMgrUtil.networkNodeKey(teTpKey.teNodeKey()), KeyId.keyId((String)Long.toString(teTpKey.teLinkTpId()))) : this.store.terminationPointKey(teTpKey);
    }

    public long teContollerId() {
        return this.providerId;
    }

    protected void bindCoreService(CoreService coreService) {
        this.coreService = coreService;
    }

    protected void unbindCoreService(CoreService coreService) {
        if (this.coreService == coreService) {
            this.coreService = null;
        }
    }

    protected void bindCfgService(NetworkConfigRegistry networkConfigRegistry) {
        this.cfgService = networkConfigRegistry;
    }

    protected void unbindCfgService(NetworkConfigRegistry networkConfigRegistry) {
        if (this.cfgService == networkConfigRegistry) {
            this.cfgService = null;
        }
    }

    protected void bindDeviceService(DeviceService deviceService) {
        this.deviceService = deviceService;
    }

    protected void unbindDeviceService(DeviceService deviceService) {
        if (this.deviceService == deviceService) {
            this.deviceService = null;
        }
    }

    protected void bindLinkService(LinkService linkService) {
        this.linkService = linkService;
    }

    protected void unbindLinkService(LinkService linkService) {
        if (this.linkService == linkService) {
            this.linkService = null;
        }
    }

    protected void bindDeviceProviderRegistry(DeviceProviderRegistry deviceProviderRegistry) {
        this.deviceProviderRegistry = deviceProviderRegistry;
    }

    protected void unbindDeviceProviderRegistry(DeviceProviderRegistry deviceProviderRegistry) {
        if (this.deviceProviderRegistry == deviceProviderRegistry) {
            this.deviceProviderRegistry = null;
        }
    }

    protected void bindLinkProviderRegistry(LinkProviderRegistry linkProviderRegistry) {
        this.linkProviderRegistry = linkProviderRegistry;
    }

    protected void unbindLinkProviderRegistry(LinkProviderRegistry linkProviderRegistry) {
        if (this.linkProviderRegistry == linkProviderRegistry) {
            this.linkProviderRegistry = null;
        }
    }

    protected void bindStore(TeTopologyStore teTopologyStore) {
        this.store = teTopologyStore;
    }

    protected void unbindStore(TeTopologyStore teTopologyStore) {
        if (this.store == teTopologyStore) {
            this.store = null;
        }
    }

    private class InternalConfigListener
    implements NetworkConfigListener {
        private InternalConfigListener() {
        }

        public void event(NetworkConfigEvent event) {
            try {
                TeTopologyManager.this.providerId = ((TeTopologyConfig)TeTopologyManager.this.cfgService.getConfig((Object)TeTopologyManager.this.appId, TeTopologyConfig.class)).providerId();
                TeTopologyManager.this.store.setProviderId(TeTopologyManager.this.providerId);
                TeTopologyManager.this.teNodeIpStart = ((TeTopologyConfig)TeTopologyManager.this.cfgService.getConfig((Object)TeTopologyManager.this.appId, TeTopologyConfig.class)).teNodeIpStart();
                TeTopologyManager.this.teNodeIpEnd = ((TeTopologyConfig)TeTopologyManager.this.cfgService.getConfig((Object)TeTopologyManager.this.appId, TeTopologyConfig.class)).teNodeIpEnd();
                TeTopologyManager.this.mdsc = ((TeTopologyConfig)TeTopologyManager.this.cfgService.getConfig((Object)TeTopologyManager.this.appId, TeTopologyConfig.class)).mdsc().equals(TeTopologyManager.MDSC_MODE);
                TeTopologyManager.this.nextTeNodeId = TeTopologyManager.this.teNodeIpStart.toInt();
            }
            catch (ConfigException e) {
                TeTopologyManager.this.log.error("Configuration error {}", (Throwable)e);
            }
        }

        public boolean isRelevant(NetworkConfigEvent event) {
            return event.configClass().equals(TeTopologyConfig.class) && (event.type() == NetworkConfigEvent.Type.CONFIG_ADDED || event.type() == NetworkConfigEvent.Type.CONFIG_UPDATED);
        }
    }

    private class LinkKeyPair {
        private TeLinkTpKey firstKey;
        private TeLinkTpKey secondKey;

        public LinkKeyPair(TeLinkTpKey firstKey) {
            this.firstKey = firstKey;
        }

        public TeLinkTpKey firstKey() {
            return this.firstKey;
        }

        public void setFirstKey(TeLinkTpKey firstKey) {
            this.firstKey = firstKey;
        }

        public TeLinkTpKey secondKey() {
            return this.secondKey;
        }

        public void setSecondKey(TeLinkTpKey secondKey) {
            this.secondKey = secondKey;
        }

        public boolean isFirstKey(TeLinkTpKey linkKey) {
            return this.firstKey == null ? false : this.firstKey.equals((Object)linkKey);
        }

        public boolean isSecondKey(TeLinkTpKey linkKey) {
            return this.secondKey == null ? false : this.secondKey.equals((Object)linkKey);
        }

        public boolean isEmpty() {
            return this.firstKey == null && this.secondKey == null;
        }

        public String toString() {
            return MoreObjects.toStringHelper((Object)this).add("firstKey", (Object)this.firstKey).add("secondKey", (Object)this.secondKey).toString();
        }
    }

    private class TopologyMergerTask
    implements Runnable {
        @Override
        public void run() {
            try {
                TeTopologyMapEvent event;
                block17: while ((event = TeTopologyManager.this.store.mapEventQueue().take()) != null) {
                    switch (event.type()) {
                        case TE_TOPOLOGY_ADDED: 
                        case TE_TOPOLOGY_UPDATED: {
                            TeTopology teTopology = TeTopologyManager.this.store.teTopology(event.teTopologyKey());
                            TeTopologyManager.this.post((Event)new TeTopologyEvent(event.type(), (TeTopologyEventSubject)teTopology));
                            if (!TeTopologyManager.this.mdsc || event.type() != TeTopologyEvent.Type.TE_TOPOLOGY_ADDED || !teTopology.flags().get(3) || !teTopology.flags().get(1)) continue block17;
                            TeTopologyManager.this.log.debug("TeTopology to be merged: {}", (Object)teTopology);
                            TeTopologyManager.this.mergeTopology(teTopology);
                            continue block17;
                        }
                        case TE_TOPOLOGY_REMOVED: {
                            TeTopologyManager.this.post((Event)new TeTopologyEvent(TeTopologyEvent.Type.TE_TOPOLOGY_REMOVED, (TeTopologyEventSubject)new DefaultTeTopology(event.teTopologyKey(), null, null, null, null)));
                            continue block17;
                        }
                        case TE_NODE_ADDED: 
                        case TE_NODE_UPDATED: {
                            if (TeTopologyManager.this.store.teTopology(event.teNodeKey().teTopologyKey()) == null) continue block17;
                            TeNode teNode = TeTopologyManager.this.store.teNode(event.teNodeKey());
                            TeTopologyManager.this.post((Event)new TeTopologyEvent(event.type(), (TeTopologyEventSubject)new TeNodeEventSubject(event.teNodeKey(), teNode)));
                            if (!TeTopologyManager.this.mdsc || !TeTopologyManager.this.isCustomizedLearnedTopology(event.teNodeKey().teTopologyKey())) continue block17;
                            TeTopologyManager.this.updateSourceTeNode(TeTopologyManager.this.mergedTopology.teNodes(), event.teNodeKey().teTopologyKey(), teNode, true);
                            continue block17;
                        }
                        case TE_NODE_REMOVED: {
                            if (TeTopologyManager.this.store.teTopology(event.teNodeKey().teTopologyKey()) == null) continue block17;
                            TeTopologyManager.this.post((Event)new TeTopologyEvent(TeTopologyEvent.Type.TE_NODE_REMOVED, (TeTopologyEventSubject)new TeNodeEventSubject(event.teNodeKey(), null)));
                            if (!TeTopologyManager.this.mdsc || !TeTopologyManager.this.isCustomizedLearnedTopology(event.teNodeKey().teTopologyKey())) continue block17;
                            TeTopologyManager.this.removeSourceTeNode(TeTopologyManager.this.mergedTopology.teNodes(), event.teNodeKey(), true);
                            continue block17;
                        }
                        case TE_LINK_ADDED: 
                        case TE_LINK_UPDATED: {
                            if (TeTopologyManager.this.store.teTopology(event.teLinkKey().teTopologyKey()) == null || TeTopologyManager.this.store.teNode(event.teLinkKey().teNodeKey()) == null) continue block17;
                            TeLink teLink = TeTopologyManager.this.store.teLink(event.teLinkKey());
                            TeTopologyManager.this.post((Event)new TeTopologyEvent(event.type(), (TeTopologyEventSubject)new TeLinkEventSubject(event.teLinkKey(), teLink)));
                            if (!TeTopologyManager.this.mdsc || !TeTopologyManager.this.isCustomizedLearnedTopology(event.teLinkKey().teTopologyKey())) continue block17;
                            HashMap teLinks = Maps.newHashMap((Map)TeTopologyManager.this.mergedTopology.teLinks());
                            TeTopologyManager.this.updateSourceTeLink(teLinks, event.teLinkKey().teTopologyKey(), teLink, true);
                            TeTopologyManager.this.updateMergedTopology(TeTopologyManager.this.mergedTopology.teNodes(), teLinks);
                            continue block17;
                        }
                        case TE_LINK_REMOVED: {
                            if (TeTopologyManager.this.store.teTopology(event.teLinkKey().teTopologyKey()) == null || TeTopologyManager.this.store.teNode(event.teLinkKey().teNodeKey()) == null) continue block17;
                            TeTopologyManager.this.post((Event)new TeTopologyEvent(TeTopologyEvent.Type.TE_LINK_REMOVED, (TeTopologyEventSubject)new TeLinkEventSubject(event.teLinkKey(), null)));
                            if (!TeTopologyManager.this.mdsc || !TeTopologyManager.this.isCustomizedLearnedTopology(event.teLinkKey().teTopologyKey())) continue block17;
                            HashMap teLinks = Maps.newHashMap((Map)TeTopologyManager.this.mergedTopology.teLinks());
                            TeTopologyManager.this.removeSourceTeLink(teLinks, event.teLinkKey(), true);
                            TeTopologyManager.this.updateMergedTopology(TeTopologyManager.this.mergedTopology.teNodes(), teLinks);
                            continue block17;
                        }
                        case NETWORK_ADDED: 
                        case NETWORK_UPDATED: {
                            Network network = TeTopologyManager.this.store.network(event.networkKey());
                            TeTopologyManager.this.post((Event)new TeTopologyEvent(event.type(), (TeTopologyEventSubject)network));
                            continue block17;
                        }
                        case NETWORK_REMOVED: {
                            TeTopologyManager.this.post((Event)new TeTopologyEvent(TeTopologyEvent.Type.NETWORK_REMOVED, (TeTopologyEventSubject)new DefaultNetwork(event.networkKey(), null, null, null, null, false, null)));
                            continue block17;
                        }
                        case NODE_ADDED: 
                        case NODE_UPDATED: {
                            if (TeTopologyManager.this.store.network(event.networkNodeKey().networkId()) == null) continue block17;
                            NetworkNode node = TeTopologyManager.this.store.networkNode(event.networkNodeKey());
                            TeTopologyManager.this.post((Event)new TeTopologyEvent(event.type(), (TeTopologyEventSubject)new NetworkNodeEventSubject(event.networkNodeKey(), node)));
                            continue block17;
                        }
                        case NODE_REMOVED: {
                            if (TeTopologyManager.this.store.network(event.networkNodeKey().networkId()) == null) continue block17;
                            TeTopologyManager.this.post((Event)new TeTopologyEvent(TeTopologyEvent.Type.NODE_REMOVED, (TeTopologyEventSubject)new NetworkNodeEventSubject(event.networkNodeKey(), null)));
                            continue block17;
                        }
                        case LINK_ADDED: 
                        case LINK_UPDATED: {
                            if (TeTopologyManager.this.store.network(event.networkLinkKey().networkId()) == null) continue block17;
                            NetworkLink link = TeTopologyManager.this.store.networkLink(event.networkLinkKey());
                            TeTopologyManager.this.post((Event)new TeTopologyEvent(event.type(), (TeTopologyEventSubject)new NetworkLinkEventSubject(event.networkLinkKey(), link)));
                            continue block17;
                        }
                        case LINK_REMOVED: {
                            if (TeTopologyManager.this.store.network(event.networkLinkKey().networkId()) == null) continue block17;
                            TeTopologyManager.this.post((Event)new TeTopologyEvent(TeTopologyEvent.Type.LINK_REMOVED, (TeTopologyEventSubject)new NetworkLinkEventSubject(event.networkLinkKey(), null)));
                            continue block17;
                        }
                    }
                }
            }
            catch (InterruptedException e) {
                TeTopologyManager.this.log.warn("TopologyMergerTask is interrupted");
            }
            catch (Exception e) {
                TeTopologyManager.this.log.warn("Unable to merge topology", (Throwable)e);
            }
        }
    }

    private class InternalTopologyProviderService
    extends AbstractProviderService<TeTopologyProvider>
    implements TeTopologyProviderService {
        protected InternalTopologyProviderService(TeTopologyProvider provider) {
            super((Provider)provider);
        }

        public void networkUpdated(Network network) {
            TeTopologyManager.this.store.updateNetwork(network);
        }

        public void networkRemoved(KeyId networkId) {
            TeTopologyManager.this.store.removeNetwork(networkId);
        }

        public void linkUpdated(NetworkLinkKey linkKey, NetworkLink link) {
            TeTopologyManager.this.store.updateNetworkLink(linkKey, link);
        }

        public void linkRemoved(NetworkLinkKey linkKey) {
            TeTopologyManager.this.store.removeNetworkLink(linkKey);
        }

        public void nodeUpdated(NetworkNodeKey nodeKey, NetworkNode node) {
            TeTopologyManager.this.store.updateNetworkNode(nodeKey, node);
        }

        public void nodeRemoved(NetworkNodeKey nodeKey) {
            TeTopologyManager.this.store.removeNetworkNode(nodeKey);
        }

        public void terminationPointUpdated(TerminationPointKey terminationPointKey, TerminationPoint terminationPoint) {
            TeTopologyManager.this.store.updateTerminationPoint(terminationPointKey, terminationPoint);
        }

        public void terminationPointRemoved(TerminationPointKey terminationPointKey) {
            TeTopologyManager.this.store.removeTerminationPoint(terminationPointKey);
        }
    }
}

