/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.tetopology.management.impl;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentMap;
import org.apache.commons.collections.MapUtils;
import org.onlab.packet.Ip4Address;
import org.onosproject.tetopology.management.api.DefaultNetwork;
import org.onosproject.tetopology.management.api.KeyId;
import org.onosproject.tetopology.management.api.Network;
import org.onosproject.tetopology.management.api.TeTopology;
import org.onosproject.tetopology.management.api.TeTopologyId;
import org.onosproject.tetopology.management.api.TeTopologyKey;
import org.onosproject.tetopology.management.api.link.DefaultNetworkLink;
import org.onosproject.tetopology.management.api.link.NetworkLink;
import org.onosproject.tetopology.management.api.link.NetworkLinkKey;
import org.onosproject.tetopology.management.api.link.TeLink;
import org.onosproject.tetopology.management.api.link.TeLinkTpGlobalKey;
import org.onosproject.tetopology.management.api.link.TeLinkTpKey;
import org.onosproject.tetopology.management.api.node.DefaultNetworkNode;
import org.onosproject.tetopology.management.api.node.DefaultTerminationPoint;
import org.onosproject.tetopology.management.api.node.NetworkNode;
import org.onosproject.tetopology.management.api.node.NetworkNodeKey;
import org.onosproject.tetopology.management.api.node.NodeTpKey;
import org.onosproject.tetopology.management.api.node.TeNode;
import org.onosproject.tetopology.management.api.node.TeNodeKey;
import org.onosproject.tetopology.management.api.node.TerminationPoint;

public final class TeMgrUtil {
    private static final String TENODE_ID = "teNodeId/";
    private static final String TELINK_ID = "/teLinkId/";
    private static final String PROVIDER_ID = "providerId/";
    private static final String CLIENT_ID = "/clientId/";
    private static final String TOPOLOGY_ID = "/topologyId/";

    private TeMgrUtil() {
    }

    public static KeyId toNetworkLinkId(TeLinkTpKey key) {
        return KeyId.keyId((String)(TENODE_ID + Ip4Address.valueOf((int)((int)key.teNodeId())).toString() + TELINK_ID + key.teLinkTpId()));
    }

    public static KeyId toNetworkId(TeTopologyId teTopologyId) {
        return KeyId.keyId((String)(PROVIDER_ID + teTopologyId.providerId() + CLIENT_ID + teTopologyId.clientId() + TOPOLOGY_ID + teTopologyId.topologyId()));
    }

    public static KeyId toNetworkId(TeTopologyKey teTopologyKey) {
        return KeyId.keyId((String)(PROVIDER_ID + teTopologyKey.providerId() + CLIENT_ID + teTopologyKey.clientId() + TOPOLOGY_ID + teTopologyKey.topologyId()));
    }

    public static NetworkNodeKey networkNodeKey(TeNodeKey teNodeKey) {
        return new NetworkNodeKey(TeMgrUtil.toNetworkId(teNodeKey.teTopologyKey()), KeyId.keyId((String)Ip4Address.valueOf((int)((int)teNodeKey.teNodeId())).toString()));
    }

    public static NetworkLinkKey networkLinkKey(TeLinkTpGlobalKey teLinkKey) {
        return new NetworkLinkKey(TeMgrUtil.toNetworkId(teLinkKey.teTopologyKey()), TeMgrUtil.toNetworkLinkId(teLinkKey.teLinkTpKey()));
    }

    public static TeTopologyId teTopologyId(TeTopology teTopology) {
        return new TeTopologyId(teTopology.teTopologyId().providerId(), teTopology.teTopologyId().clientId(), teTopology.teTopologyIdStringValue());
    }

    private static TerminationPoint tpBuilder(long teTpId) {
        return new DefaultTerminationPoint(KeyId.keyId((String)Long.toString(teTpId)), null, Long.valueOf(teTpId));
    }

    public static NetworkNode nodeBuilder(KeyId id, TeNode teNode) {
        ArrayList supportingNodeIds = null;
        if (teNode.supportingTeNodeId() != null) {
            supportingNodeIds = Lists.newArrayList((Object[])new NetworkNodeKey[]{TeMgrUtil.networkNodeKey(teNode.supportingTeNodeId())});
        }
        ConcurrentMap tps = Maps.newConcurrentMap();
        for (Long teTpid : teNode.teTerminationPointIds()) {
            tps.put(KeyId.keyId((String)Long.toString(teTpid)), TeMgrUtil.tpBuilder(teTpid));
        }
        return new DefaultNetworkNode(id, (List)supportingNodeIds, teNode, (Map)tps);
    }

    public static NodeTpKey nodeTpKey(TeLinkTpKey teLinkKey) {
        return new NodeTpKey(KeyId.keyId((String)Ip4Address.valueOf((int)((int)teLinkKey.teNodeId())).toString()), KeyId.keyId((String)Long.toString(teLinkKey.teLinkTpId())));
    }

    public static NetworkLink linkBuilder(KeyId id, TeLink teLink) {
        NodeTpKey source = TeMgrUtil.nodeTpKey(teLink.teLinkKey());
        NodeTpKey destination = null;
        if (teLink.peerTeLinkKey() != null) {
            destination = TeMgrUtil.nodeTpKey(teLink.peerTeLinkKey());
        }
        ArrayList supportingLinkIds = null;
        if (teLink.supportingTeLinkId() != null) {
            supportingLinkIds = Lists.newArrayList((Object[])new NetworkLinkKey[]{TeMgrUtil.networkLinkKey(teLink.supportingTeLinkId())});
        }
        return new DefaultNetworkLink(id, source, destination, supportingLinkIds, teLink);
    }

    public static Network networkBuilder(TeTopology teTopology) {
        KeyId networkId = TeMgrUtil.toNetworkId(teTopology.teTopologyId());
        TeTopologyId topologyId = TeMgrUtil.teTopologyId(teTopology);
        HashMap nodes = null;
        if (MapUtils.isNotEmpty((Map)teTopology.teNodes())) {
            nodes = Maps.newHashMap();
            for (TeNode tenode : teTopology.teNodes().values()) {
                KeyId key = KeyId.keyId((String)Ip4Address.valueOf((int)((int)tenode.teNodeId())).toString());
                nodes.put(key, TeMgrUtil.nodeBuilder(key, tenode));
            }
        }
        HashMap links = null;
        if (MapUtils.isNotEmpty((Map)teTopology.teLinks())) {
            links = Maps.newHashMap();
            for (TeLink telink : teTopology.teLinks().values()) {
                KeyId key = TeMgrUtil.toNetworkLinkId(telink.teLinkKey());
                links.put(key, TeMgrUtil.linkBuilder(key, telink));
            }
        }
        return new DefaultNetwork(networkId, null, (Map)nodes, (Map)links, topologyId, false, teTopology.ownerId());
    }
}

