/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.tetopology.management.impl;

import com.google.common.base.MoreObjects;
import com.google.common.base.Objects;
import com.google.common.collect.Lists;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.MapUtils;
import org.onosproject.tetopology.management.api.CommonTopologyData;
import org.onosproject.tetopology.management.api.TeTopology;
import org.onosproject.tetopology.management.api.link.TeLinkTpGlobalKey;
import org.onosproject.tetopology.management.api.link.TeLinkTpKey;
import org.onosproject.tetopology.management.api.node.TeNodeKey;

public class InternalTeTopology {
    private String teTopologyId;
    private List<TeNodeKey> teNodeKeys;
    private List<TeLinkTpGlobalKey> teLinkKeys;
    private CommonTopologyData topologyData;
    private long nextTeNodeId = 0L;
    private boolean childUpdate;

    public InternalTeTopology(TeTopology teTopology) {
        this.teTopologyId = teTopology.teTopologyIdStringValue();
        this.topologyData = new CommonTopologyData(teTopology);
        if (MapUtils.isNotEmpty((Map)teTopology.teNodes())) {
            this.teNodeKeys = Lists.newArrayList();
            for (Map.Entry entry : teTopology.teNodes().entrySet()) {
                this.teNodeKeys.add(new TeNodeKey(teTopology.teTopologyId(), ((Long)entry.getKey()).longValue()));
            }
        }
        if (MapUtils.isNotEmpty((Map)teTopology.teLinks())) {
            this.teLinkKeys = Lists.newArrayList();
            for (Map.Entry entry : teTopology.teLinks().entrySet()) {
                this.teLinkKeys.add(new TeLinkTpGlobalKey(teTopology.teTopologyId(), (TeLinkTpKey)entry.getKey()));
            }
        }
    }

    public InternalTeTopology(String teTopologyId) {
        this.teTopologyId = teTopologyId;
    }

    public String teTopologyId() {
        return this.teTopologyId;
    }

    public List<TeNodeKey> teNodeKeys() {
        return this.teNodeKeys;
    }

    public void setTeNodeKeys(List<TeNodeKey> teNodeKeys) {
        this.teNodeKeys = teNodeKeys;
    }

    public List<TeLinkTpGlobalKey> teLinkKeys() {
        return this.teLinkKeys;
    }

    public void setTeLinkKeys(List<TeLinkTpGlobalKey> teLinkKeys) {
        this.teLinkKeys = teLinkKeys;
    }

    public CommonTopologyData topologyData() {
        return this.topologyData;
    }

    public void setTopologydata(CommonTopologyData topologyData) {
        this.topologyData = topologyData;
    }

    public long nextTeNodeId() {
        return this.nextTeNodeId;
    }

    public void setNextTeNodeId(long nextTeNodeId) {
        this.nextTeNodeId = nextTeNodeId;
    }

    public boolean childUpdate() {
        return this.childUpdate;
    }

    public void setChildUpdate(boolean childUpdate) {
        this.childUpdate = childUpdate;
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.teTopologyId, this.teNodeKeys, this.teLinkKeys, this.topologyData});
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object instanceof InternalTeTopology) {
            InternalTeTopology that = (InternalTeTopology)object;
            return Objects.equal((Object)this.teTopologyId, (Object)that.teTopologyId) && Objects.equal(this.teNodeKeys, that.teNodeKeys) && Objects.equal(this.teLinkKeys, that.teLinkKeys) && Objects.equal((Object)this.topologyData, (Object)that.topologyData);
        }
        return false;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("teTopologyId", (Object)this.teTopologyId).add("teNodeKeys", this.teNodeKeys).add("teLinkKeys", this.teLinkKeys).add("topologyData", (Object)this.topologyData).add("nextTeNodeId", this.nextTeNodeId).add("childUpdate", this.childUpdate).toString();
    }
}

