/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.tetopology.management.impl;

import com.google.common.base.MoreObjects;
import com.google.common.base.Objects;
import com.google.common.collect.Lists;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.onosproject.tetopology.management.api.TeTopologyKey;
import org.onosproject.tetopology.management.api.link.TeLinkTpGlobalKey;
import org.onosproject.tetopology.management.api.node.CommonNodeData;
import org.onosproject.tetopology.management.api.node.ConnectivityMatrixKey;
import org.onosproject.tetopology.management.api.node.NetworkNodeKey;
import org.onosproject.tetopology.management.api.node.TeNode;
import org.onosproject.tetopology.management.api.node.TeNodeKey;
import org.onosproject.tetopology.management.api.node.TtpKey;

public class InternalTeNode {
    private CommonNodeData teData;
    private TeTopologyKey underlayTopologyKey;
    private TeNodeKey supportNodeKey;
    private TeNodeKey sourceTeNodeKey;
    private List<ConnectivityMatrixKey> connMatrixKeys;
    private List<TeLinkTpGlobalKey> teLinkTpKeys;
    private List<TeLinkTpGlobalKey> teTpKeys;
    private List<TtpKey> ttpKeys;
    private NetworkNodeKey networkNodeKey;
    private boolean parentUpdate;
    private boolean childUpdate;
    private long nextTeLinkId;

    public InternalTeNode(TeNodeKey nodeKey, TeNode node, NetworkNodeKey networkNodeKey, boolean parentUpdate) {
        this.networkNodeKey = networkNodeKey;
        this.parentUpdate = parentUpdate;
        this.underlayTopologyKey = node.underlayTeTopologyId();
        this.supportNodeKey = node.supportingTeNodeId();
        this.sourceTeNodeKey = node.sourceTeNodeId();
        this.teData = new CommonNodeData(node);
        if (MapUtils.isNotEmpty((Map)node.connectivityMatrices())) {
            this.connMatrixKeys = Lists.newArrayList();
            for (Map.Entry entry : node.connectivityMatrices().entrySet()) {
                this.connMatrixKeys.add(new ConnectivityMatrixKey(nodeKey, ((Long)entry.getKey()).longValue()));
            }
        }
        if (MapUtils.isNotEmpty((Map)node.tunnelTerminationPoints())) {
            this.ttpKeys = Lists.newArrayList();
            for (Map.Entry entry : node.tunnelTerminationPoints().entrySet()) {
                this.ttpKeys.add(new TtpKey(nodeKey, ((Long)entry.getKey()).longValue()));
            }
        }
        if (CollectionUtils.isNotEmpty((Collection)node.teLinkIds())) {
            this.teLinkTpKeys = Lists.newArrayList();
            for (Long linkId : node.teLinkIds()) {
                this.teLinkTpKeys.add(new TeLinkTpGlobalKey(nodeKey, linkId.longValue()));
            }
        }
        if (CollectionUtils.isNotEmpty((Collection)node.teTerminationPointIds())) {
            this.teTpKeys = Lists.newArrayList();
            for (Long tpId : node.teTerminationPointIds()) {
                this.teTpKeys.add(new TeLinkTpGlobalKey(nodeKey, tpId.longValue()));
            }
        }
    }

    public CommonNodeData teData() {
        return this.teData;
    }

    public void setTeData(CommonNodeData teData) {
        this.teData = teData;
    }

    public TeTopologyKey underlayTopologyKey() {
        return this.underlayTopologyKey;
    }

    public void setUnderlayTopologyKey(TeTopologyKey underlayTopologyKey) {
        this.underlayTopologyKey = underlayTopologyKey;
    }

    public TeNodeKey supportNodeKey() {
        return this.supportNodeKey;
    }

    public void setSupportNodeKey(TeNodeKey supportNodeKey) {
        this.supportNodeKey = supportNodeKey;
    }

    public TeNodeKey sourceTeNodeKey() {
        return this.sourceTeNodeKey;
    }

    public void setSourceTeNodeKey(TeNodeKey sourceTeNodeKey) {
        this.sourceTeNodeKey = sourceTeNodeKey;
    }

    public List<ConnectivityMatrixKey> connMatrixKeys() {
        return this.connMatrixKeys;
    }

    public void setConnMatrixKeys(List<ConnectivityMatrixKey> connMatrixKeys) {
        this.connMatrixKeys = connMatrixKeys;
    }

    public List<TeLinkTpGlobalKey> teLinkTpKeys() {
        return this.teLinkTpKeys;
    }

    public void setTeLinkTpKeys(List<TeLinkTpGlobalKey> teLinkTpKeys) {
        this.teLinkTpKeys = teLinkTpKeys;
    }

    public List<TeLinkTpGlobalKey> teTpKeys() {
        return this.teTpKeys;
    }

    public void setTeTpKeys(List<TeLinkTpGlobalKey> teTpKeys) {
        this.teTpKeys = teTpKeys;
    }

    public List<TtpKey> ttpKeys() {
        return this.ttpKeys;
    }

    public void setTtpKeys(List<TtpKey> ttpKeys) {
        this.ttpKeys = ttpKeys;
    }

    public NetworkNodeKey networkNodeKey() {
        return this.networkNodeKey;
    }

    public long nextTeLinkId() {
        return this.nextTeLinkId;
    }

    public void setNextTeLinkId(long nextTeLinkId) {
        this.nextTeLinkId = nextTeLinkId;
    }

    public boolean parentUpdate() {
        return this.parentUpdate;
    }

    public boolean childUpdate() {
        return this.childUpdate;
    }

    public void setChildUpdate(boolean childUpdate) {
        this.childUpdate = childUpdate;
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.teData, this.underlayTopologyKey, this.supportNodeKey, this.sourceTeNodeKey, this.connMatrixKeys, this.teLinkTpKeys, this.ttpKeys, this.networkNodeKey});
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object instanceof InternalTeNode) {
            InternalTeNode that = (InternalTeNode)object;
            return Objects.equal((Object)this.teData, (Object)that.teData) && Objects.equal((Object)this.underlayTopologyKey, (Object)that.underlayTopologyKey) && Objects.equal((Object)this.supportNodeKey, (Object)that.supportNodeKey) && Objects.equal((Object)this.sourceTeNodeKey, (Object)that.sourceTeNodeKey) && Objects.equal(this.connMatrixKeys, that.connMatrixKeys) && Objects.equal(this.teLinkTpKeys, that.teLinkTpKeys) && Objects.equal(this.ttpKeys, that.ttpKeys) && Objects.equal((Object)this.networkNodeKey, (Object)that.networkNodeKey);
        }
        return false;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("teData", (Object)this.teData).add("underlayTopologyKey", (Object)this.underlayTopologyKey).add("supportNodeKey", (Object)this.supportNodeKey).add("sourceTeNodeKey", (Object)this.sourceTeNodeKey).add("connMatrixKeys", this.connMatrixKeys).add("teLinkTpKeys", this.teLinkTpKeys).add("ttpKeys", this.ttpKeys).add("nextTeLinkId", this.nextTeLinkId).add("networkNodeKey", (Object)this.networkNodeKey).add("parentUpdate", this.parentUpdate).add("childUpdate", this.childUpdate).toString();
    }
}

