/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.tetopology.management.impl;

import com.google.common.base.MoreObjects;
import com.google.common.base.Objects;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.MapUtils;
import org.onosproject.tetopology.management.api.KeyId;
import org.onosproject.tetopology.management.api.node.NetworkNode;
import org.onosproject.tetopology.management.api.node.NetworkNodeKey;
import org.onosproject.tetopology.management.api.node.TeNodeKey;

public class InternalNetworkNode {
    private List<NetworkNodeKey> supportingNodeIds;
    private List<KeyId> tpIds;
    private TeNodeKey teNodeKey;
    private boolean parentUpdate;
    private boolean childUpdate;

    public InternalNetworkNode(NetworkNode node, boolean parentUpdate) {
        List<Object> list = this.supportingNodeIds = node.supportingNodeIds() == null ? null : Lists.newArrayList((Iterable)node.supportingNodeIds());
        if (MapUtils.isNotEmpty((Map)node.terminationPoints())) {
            this.tpIds = Lists.newArrayList();
            for (Map.Entry entry : node.terminationPoints().entrySet()) {
                this.tpIds.add((KeyId)entry.getKey());
            }
        }
        this.parentUpdate = parentUpdate;
    }

    public List<NetworkNodeKey> supportingNodeIds() {
        return this.supportingNodeIds == null ? null : ImmutableList.copyOf(this.supportingNodeIds);
    }

    public void setSupportingNodeIds(List<NetworkNodeKey> supportingNodeIds) {
        this.supportingNodeIds = supportingNodeIds == null ? null : Lists.newArrayList(supportingNodeIds);
    }

    public List<KeyId> tpIds() {
        return this.tpIds;
    }

    public void setTpIds(List<KeyId> tpIds) {
        this.tpIds = tpIds;
    }

    public TeNodeKey teNodeKey() {
        return this.teNodeKey;
    }

    public void setTeNodeKey(TeNodeKey teNodeKey) {
        this.teNodeKey = teNodeKey;
    }

    public boolean parentUpdate() {
        return this.parentUpdate;
    }

    public boolean childUpdate() {
        return this.childUpdate;
    }

    public void setChildUpdate(boolean childUpdate) {
        this.childUpdate = childUpdate;
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.supportingNodeIds, this.tpIds, this.teNodeKey});
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object instanceof InternalNetworkNode) {
            InternalNetworkNode that = (InternalNetworkNode)object;
            return Objects.equal(this.supportingNodeIds, that.supportingNodeIds) && Objects.equal(this.tpIds, that.tpIds) && Objects.equal((Object)this.teNodeKey, (Object)that.teNodeKey);
        }
        return false;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("supportingNodeIds", this.supportingNodeIds).add("tpIds", this.tpIds).add("teNodeKey", (Object)this.teNodeKey).add("parentUpdate", this.parentUpdate).add("childUpdate", this.childUpdate).toString();
    }
}

