/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.tetopology.management.impl;

import com.google.common.base.MoreObjects;
import com.google.common.base.Objects;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.util.List;
import org.onosproject.tetopology.management.api.link.NetworkLink;
import org.onosproject.tetopology.management.api.link.NetworkLinkKey;
import org.onosproject.tetopology.management.api.link.TeLinkTpGlobalKey;
import org.onosproject.tetopology.management.api.node.NodeTpKey;

public class InternalNetworkLink {
    private NodeTpKey source;
    private NodeTpKey destination;
    private List<NetworkLinkKey> supportingLinkIds;
    private TeLinkTpGlobalKey teLinkKey;
    private boolean parentUpdate;

    public InternalNetworkLink(NetworkLink link, boolean parentUpdate) {
        this.source = link.source();
        this.destination = link.destination();
        this.supportingLinkIds = link.supportingLinkIds() == null ? null : Lists.newArrayList((Iterable)link.supportingLinkIds());
        this.parentUpdate = parentUpdate;
    }

    public NodeTpKey source() {
        return this.source;
    }

    public NodeTpKey destination() {
        return this.destination;
    }

    public List<NetworkLinkKey> supportingLinkIds() {
        return this.supportingLinkIds == null ? null : ImmutableList.copyOf(this.supportingLinkIds);
    }

    public TeLinkTpGlobalKey teLinkKey() {
        return this.teLinkKey;
    }

    public void setTeLinkKey(TeLinkTpGlobalKey teLinkKey) {
        this.teLinkKey = teLinkKey;
    }

    public boolean parentUpdate() {
        return this.parentUpdate;
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.source, this.destination, this.supportingLinkIds, this.teLinkKey});
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object instanceof InternalNetworkLink) {
            InternalNetworkLink that = (InternalNetworkLink)object;
            return Objects.equal((Object)this.source, (Object)that.source) && Objects.equal((Object)this.destination, (Object)that.destination) && Objects.equal(this.supportingLinkIds, that.supportingLinkIds) && Objects.equal((Object)this.teLinkKey, (Object)that.teLinkKey);
        }
        return false;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("source", (Object)this.source).add("destination", (Object)this.destination).add("supportingLinkIds", this.supportingLinkIds).add("teLinkKey", (Object)this.teLinkKey).toString();
    }
}

