/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.tetopology.management.impl;

import com.google.common.base.MoreObjects;
import com.google.common.base.Objects;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.MapUtils;
import org.onosproject.tetopology.management.api.KeyId;
import org.onosproject.tetopology.management.api.Network;
import org.onosproject.tetopology.management.api.TeTopologyKey;
import org.onosproject.tetopology.management.api.link.NetworkLinkKey;
import org.onosproject.tetopology.management.api.node.NetworkNodeKey;

public class InternalNetwork {
    private TeTopologyKey teTopologyKey;
    private List<KeyId> supportingNetworkIds;
    private boolean serverProvided;
    private List<NetworkNodeKey> nodeIds;
    private List<NetworkLinkKey> linkIds;
    private boolean childUpdate = false;

    public InternalNetwork(Network network) {
        this.supportingNetworkIds = network.supportingNetworkIds() == null ? null : Lists.newArrayList((Iterable)network.supportingNetworkIds());
        this.serverProvided = network.isServerProvided();
        if (MapUtils.isNotEmpty((Map)network.nodes())) {
            this.nodeIds = Lists.newArrayList();
            for (Map.Entry entry : network.nodes().entrySet()) {
                this.nodeIds.add(new NetworkNodeKey(network.networkId(), (KeyId)entry.getKey()));
            }
        }
        if (MapUtils.isNotEmpty((Map)network.links())) {
            this.linkIds = Lists.newArrayList();
            for (Map.Entry entry : network.links().entrySet()) {
                this.linkIds.add(new NetworkLinkKey(network.networkId(), (KeyId)entry.getKey()));
            }
        }
    }

    public InternalNetwork() {
    }

    public List<KeyId> supportingNetworkIds() {
        if (this.supportingNetworkIds == null) {
            return null;
        }
        return ImmutableList.copyOf(this.supportingNetworkIds);
    }

    public boolean serverProvided() {
        return this.serverProvided;
    }

    public void setServerProvided(boolean serverProvided) {
        this.serverProvided = serverProvided;
    }

    public List<NetworkNodeKey> nodeIds() {
        return this.nodeIds;
    }

    public TeTopologyKey teTopologyKey() {
        return this.teTopologyKey;
    }

    public void setTeTopologyKey(TeTopologyKey teTopologyKey) {
        this.teTopologyKey = teTopologyKey;
    }

    public void setNodeIds(List<NetworkNodeKey> nodeIds) {
        this.nodeIds = nodeIds;
    }

    public List<NetworkLinkKey> linkIds() {
        return this.linkIds;
    }

    public void setLinkIds(List<NetworkLinkKey> linkIds) {
        this.linkIds = linkIds;
    }

    public boolean childUpdate() {
        return this.childUpdate;
    }

    public void setChildUpdate(boolean childUpdate) {
        this.childUpdate = childUpdate;
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.teTopologyKey, this.nodeIds, this.linkIds, this.supportingNetworkIds, this.serverProvided});
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object instanceof InternalNetwork) {
            InternalNetwork that = (InternalNetwork)object;
            return Objects.equal((Object)this.teTopologyKey, (Object)that.teTopologyKey) && Objects.equal(this.nodeIds, that.nodeIds) && Objects.equal(this.linkIds, that.linkIds) && Objects.equal(this.supportingNetworkIds, that.supportingNetworkIds) && Objects.equal((Object)this.serverProvided, (Object)that.serverProvided);
        }
        return false;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("teTopologyKey", (Object)this.teTopologyKey).add("nodeIds", this.nodeIds).add("linkIds", this.linkIds).add("supportingNetworkIds", this.supportingNetworkIds).add("serverProvided", this.serverProvided).add("childUpdate", this.childUpdate).toString();
    }
}

