/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.tetopology.management.impl;

import com.esotericsoftware.kryo.Serializer;
import com.esotericsoftware.kryo.serializers.JavaSerializer;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.felix.scr.annotations.Activate;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Deactivate;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.ReferenceCardinality;
import org.apache.felix.scr.annotations.Service;
import org.onlab.util.KryoNamespace;
import org.onosproject.net.DeviceId;
import org.onosproject.store.AbstractStore;
import org.onosproject.store.serializers.KryoNamespaces;
import org.onosproject.store.service.AtomicCounter;
import org.onosproject.store.service.ConsistentMap;
import org.onosproject.store.service.ConsistentMapBuilder;
import org.onosproject.store.service.MapEvent;
import org.onosproject.store.service.MapEventListener;
import org.onosproject.store.service.StorageService;
import org.onosproject.tetopology.management.api.CommonTopologyData;
import org.onosproject.tetopology.management.api.DefaultNetwork;
import org.onosproject.tetopology.management.api.DefaultTeTopologies;
import org.onosproject.tetopology.management.api.DefaultTeTopology;
import org.onosproject.tetopology.management.api.EncodingType;
import org.onosproject.tetopology.management.api.KeyId;
import org.onosproject.tetopology.management.api.LongValue;
import org.onosproject.tetopology.management.api.Network;
import org.onosproject.tetopology.management.api.OptimizationType;
import org.onosproject.tetopology.management.api.ProviderClientId;
import org.onosproject.tetopology.management.api.SwitchingType;
import org.onosproject.tetopology.management.api.TeStatus;
import org.onosproject.tetopology.management.api.TeTopologies;
import org.onosproject.tetopology.management.api.TeTopology;
import org.onosproject.tetopology.management.api.TeTopologyEvent;
import org.onosproject.tetopology.management.api.TeTopologyId;
import org.onosproject.tetopology.management.api.TeTopologyKey;
import org.onosproject.tetopology.management.api.TeUtils;
import org.onosproject.tetopology.management.api.link.AsNumber;
import org.onosproject.tetopology.management.api.link.CommonLinkData;
import org.onosproject.tetopology.management.api.link.ConnectivityMatrixId;
import org.onosproject.tetopology.management.api.link.DefaultNetworkLink;
import org.onosproject.tetopology.management.api.link.DefaultTeLink;
import org.onosproject.tetopology.management.api.link.ElementType;
import org.onosproject.tetopology.management.api.link.ExternalLink;
import org.onosproject.tetopology.management.api.link.Label;
import org.onosproject.tetopology.management.api.link.LinkBandwidth;
import org.onosproject.tetopology.management.api.link.NetworkLink;
import org.onosproject.tetopology.management.api.link.NetworkLinkKey;
import org.onosproject.tetopology.management.api.link.OduResource;
import org.onosproject.tetopology.management.api.link.PathElement;
import org.onosproject.tetopology.management.api.link.TeIpv4;
import org.onosproject.tetopology.management.api.link.TeIpv6;
import org.onosproject.tetopology.management.api.link.TeLink;
import org.onosproject.tetopology.management.api.link.TeLinkId;
import org.onosproject.tetopology.management.api.link.TeLinkTpGlobalKey;
import org.onosproject.tetopology.management.api.link.TeLinkTpKey;
import org.onosproject.tetopology.management.api.link.TePathAttributes;
import org.onosproject.tetopology.management.api.link.TunnelProtectionType;
import org.onosproject.tetopology.management.api.link.UnderlayAbstractPath;
import org.onosproject.tetopology.management.api.link.UnderlayBackupPath;
import org.onosproject.tetopology.management.api.link.UnderlayPath;
import org.onosproject.tetopology.management.api.link.UnderlayPrimaryPath;
import org.onosproject.tetopology.management.api.link.UnnumberedLink;
import org.onosproject.tetopology.management.api.node.CommonNodeData;
import org.onosproject.tetopology.management.api.node.ConnectivityMatrix;
import org.onosproject.tetopology.management.api.node.ConnectivityMatrixKey;
import org.onosproject.tetopology.management.api.node.DefaultNetworkNode;
import org.onosproject.tetopology.management.api.node.DefaultTeNode;
import org.onosproject.tetopology.management.api.node.DefaultTerminationPoint;
import org.onosproject.tetopology.management.api.node.DefaultTunnelTerminationPoint;
import org.onosproject.tetopology.management.api.node.LocalLinkConnectivity;
import org.onosproject.tetopology.management.api.node.NetworkNode;
import org.onosproject.tetopology.management.api.node.NetworkNodeKey;
import org.onosproject.tetopology.management.api.node.NodeTpKey;
import org.onosproject.tetopology.management.api.node.TeNode;
import org.onosproject.tetopology.management.api.node.TeNodeKey;
import org.onosproject.tetopology.management.api.node.TerminationPoint;
import org.onosproject.tetopology.management.api.node.TerminationPointKey;
import org.onosproject.tetopology.management.api.node.TtpKey;
import org.onosproject.tetopology.management.api.node.TunnelTerminationPoint;
import org.onosproject.tetopology.management.impl.InternalNetwork;
import org.onosproject.tetopology.management.impl.InternalNetworkLink;
import org.onosproject.tetopology.management.impl.InternalNetworkNode;
import org.onosproject.tetopology.management.impl.InternalTeLink;
import org.onosproject.tetopology.management.impl.InternalTeNode;
import org.onosproject.tetopology.management.impl.InternalTeTopology;
import org.onosproject.tetopology.management.impl.InternalTerminationPoint;
import org.onosproject.tetopology.management.impl.TeMgrUtil;
import org.onosproject.tetopology.management.impl.TeTopologyMapEvent;
import org.onosproject.tetopology.management.impl.TeTopologyStore;
import org.onosproject.tetopology.management.impl.TeTopologyStoreDelegate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(immediate=true)
@Service
public class DistributedTeTopologyStore
extends AbstractStore<TeTopologyEvent, TeTopologyStoreDelegate>
implements TeTopologyStore {
    private static final String STORE_NAME = "TE_NETWORK_TOPOLOGY_STORE";
    private static final String TETOPOLOGYKEY_INTERNALTETOPOLOGY = "TeTopologyKey-InternalTeTopology";
    private static final String NETWORKID_NETWORK = "NetworkId-InternalNetwork";
    private static final String TENODEKEY_INTERNALTENODE = "TeNodeKey-InternalTeNode";
    private static final String CONNMATRIXKEY_CONNECTIVITYMATRIX = "ConnMatrixKey-ConnectivityMatrix";
    private static final String NETWORKNODEKEY_INTERNALNETWORKNODE = "NetworkNodeKey-InternalNetworkNode";
    private static final String TELINKGLOBALKEY_INTERNALTELINK = "TeLinkGlobalKey-InternalTeLink";
    private static final String NETWORKLINKKEY_INTERNALNETWORKLINK = "NetworkLinkKey-InternalNetworkLink";
    private static final String TPKEY_INTERNALTERMINATIONPOINT = "tpKey-InternalTerminationPoint";
    private static final String TELINKTPGLOBALKEY_TERMINATIONPOINTKEY = "TeLinkGlobalKey-TerminationPointKey";
    private static final String TTPKEY_TUNNELTERMINATIONPOINT = "TtpKey-TunnelTerminationPoint";
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected StorageService storageService;
    private ConsistentMap<TeTopologyKey, InternalTeTopology> teTopologyConsistentMap;
    private Map<TeTopologyKey, InternalTeTopology> teTopologyMap;
    private AtomicCounter nextTeTopologyId;
    private final MapEventListener<TeTopologyKey, InternalTeTopology> teTopologyListener = new InternalTeTopologyListener();
    private ConsistentMap<KeyId, InternalNetwork> networkConsistentMap;
    private Map<KeyId, InternalNetwork> networkMap;
    private final MapEventListener<KeyId, InternalNetwork> networkListener = new InternalNetworkListener();
    private ConsistentMap<TeNodeKey, InternalTeNode> teNodeConsistentMap;
    private Map<TeNodeKey, InternalTeNode> teNodeMap;
    private ConsistentMap<ConnectivityMatrixKey, ConnectivityMatrix> connMatrixConsistentMap;
    private Map<ConnectivityMatrixKey, ConnectivityMatrix> connMatrixMap;
    private ConsistentMap<TtpKey, TunnelTerminationPoint> ttpConsistentMap;
    private Map<TtpKey, TunnelTerminationPoint> ttpMap;
    private final MapEventListener<TeNodeKey, InternalTeNode> teNodeListener = new InternalTeNodeListener();
    private ConsistentMap<NetworkNodeKey, InternalNetworkNode> networkNodeConsistentMap;
    private Map<NetworkNodeKey, InternalNetworkNode> networkNodeMap;
    private final MapEventListener<NetworkNodeKey, InternalNetworkNode> networkNodeListener = new InternalNetworkNodeListener();
    private ConsistentMap<TeLinkTpGlobalKey, InternalTeLink> teLinkConsistentMap;
    private Map<TeLinkTpGlobalKey, InternalTeLink> teLinkMap;
    private final MapEventListener<TeLinkTpGlobalKey, InternalTeLink> teLinkListener = new InternalTeLinkListener();
    private ConsistentMap<NetworkLinkKey, InternalNetworkLink> networkLinkConsistentMap;
    private Map<NetworkLinkKey, InternalNetworkLink> networkLinkMap;
    private final MapEventListener<NetworkLinkKey, InternalNetworkLink> networkLinkListener = new InternalNetworkLinkListener();
    private ConsistentMap<TerminationPointKey, InternalTerminationPoint> tpConsistentMap;
    private Map<TerminationPointKey, InternalTerminationPoint> tpMap;
    private ConsistentMap<TeLinkTpGlobalKey, TerminationPointKey> tpKeyConsistentMap;
    private Map<TeLinkTpGlobalKey, TerminationPointKey> tpKeyMap;
    private final BlockingQueue<TeTopologyMapEvent> mapEventQueue = new LinkedBlockingQueue<TeTopologyMapEvent>();
    private long providerId;
    private static final org.onosproject.store.service.Serializer TETOPOLOGY_SERIALIZER = org.onosproject.store.service.Serializer.using((KryoNamespace)new KryoNamespace.Builder().register(KryoNamespaces.API).register(new Class[]{TeTopologyKey.class}).register(new Class[]{ProviderClientId.class}).register(new Class[]{TeNodeKey.class}).register(new Class[]{TeLinkTpGlobalKey.class}).register(new Class[]{CommonTopologyData.class}).register(new Class[]{KeyId.class}).register(new Class[]{OptimizationType.class}).register((Serializer)new JavaSerializer(), new Class[]{BitSet.class}).register(new Class[]{InternalTeTopology.class}).register(new Class[]{InternalNetwork.class}).register(new Class[]{InternalTerminationPoint.class}).register(new Class[]{InternalTeNode.class}).register(new Class[]{InternalNetworkNode.class}).register(new Class[]{CommonNodeData.class}).register(new Class[]{ConnectivityMatrixKey.class}).register(new Class[]{ConnectivityMatrix.class}).register(new Class[]{TtpKey.class}).register(new Class[]{NetworkNodeKey.class}).register(new Class[]{TeStatus.class}).register(new Class[]{ElementType.class}).register(new Class[]{TeIpv4.class}).register(new Class[]{TeIpv6.class}).register(new Class[]{AsNumber.class}).register(new Class[]{Label.class}).register(new Class[]{UnnumberedLink.class}).register(new Class[]{TeLinkId.class}).register(new Class[]{ConnectivityMatrixId.class}).register(new Class[]{InternalTeLink.class}).register(new Class[]{InternalNetworkLink.class}).register(new Class[]{TeLinkTpKey.class}).register(new Class[]{NetworkLinkKey.class}).register(new Class[]{NodeTpKey.class}).register(new Class[]{CommonLinkData.class}).register(new Class[]{SwitchingType.class}).register(new Class[]{EncodingType.class}).register(new Class[]{ExternalLink.class}).register(new Class[]{UnderlayPath.class}).register(new Class[]{LinkBandwidth.class}).register(new Class[]{OduResource.class}).register(new Class[]{PathElement.class}).register(new Class[]{UnderlayAbstractPath.class}).register(new Class[]{UnderlayBackupPath.class}).register(new Class[]{UnderlayPrimaryPath.class}).register(new Class[]{TePathAttributes.class}).register(new Class[]{TerminationPoint.class}).register(new Class[]{TunnelTerminationPoint.class}).register(new Class[]{DefaultTunnelTerminationPoint.class}).register(new Class[]{TerminationPointKey.class}).register(new Class[]{TunnelProtectionType.class}).register(new Class[]{LongValue.class}).register(new Class[]{LocalLinkConnectivity.class}).build());

    @Activate
    public void activate() {
        this.teTopologyConsistentMap = (ConsistentMap)((ConsistentMapBuilder)((ConsistentMapBuilder)((ConsistentMapBuilder)this.storageService.consistentMapBuilder().withSerializer(TETOPOLOGY_SERIALIZER)).withName(TETOPOLOGYKEY_INTERNALTETOPOLOGY)).withRelaxedReadConsistency()).build();
        this.teTopologyConsistentMap.addListener(this.teTopologyListener);
        this.teTopologyMap = this.teTopologyConsistentMap.asJavaMap();
        this.networkConsistentMap = (ConsistentMap)((ConsistentMapBuilder)((ConsistentMapBuilder)((ConsistentMapBuilder)this.storageService.consistentMapBuilder().withSerializer(TETOPOLOGY_SERIALIZER)).withName(NETWORKID_NETWORK)).withRelaxedReadConsistency()).build();
        this.networkConsistentMap.addListener(this.networkListener);
        this.networkMap = this.networkConsistentMap.asJavaMap();
        this.teNodeConsistentMap = (ConsistentMap)((ConsistentMapBuilder)((ConsistentMapBuilder)((ConsistentMapBuilder)this.storageService.consistentMapBuilder().withSerializer(TETOPOLOGY_SERIALIZER)).withName(TENODEKEY_INTERNALTENODE)).withRelaxedReadConsistency()).build();
        this.teNodeConsistentMap.addListener(this.teNodeListener);
        this.teNodeMap = this.teNodeConsistentMap.asJavaMap();
        this.connMatrixConsistentMap = (ConsistentMap)((ConsistentMapBuilder)((ConsistentMapBuilder)((ConsistentMapBuilder)this.storageService.consistentMapBuilder().withSerializer(TETOPOLOGY_SERIALIZER)).withName(CONNMATRIXKEY_CONNECTIVITYMATRIX)).withRelaxedReadConsistency()).build();
        this.connMatrixMap = this.connMatrixConsistentMap.asJavaMap();
        this.networkNodeConsistentMap = (ConsistentMap)((ConsistentMapBuilder)((ConsistentMapBuilder)((ConsistentMapBuilder)this.storageService.consistentMapBuilder().withSerializer(TETOPOLOGY_SERIALIZER)).withName(NETWORKNODEKEY_INTERNALNETWORKNODE)).withRelaxedReadConsistency()).build();
        this.networkNodeConsistentMap.addListener(this.networkNodeListener);
        this.networkNodeMap = this.networkNodeConsistentMap.asJavaMap();
        this.teLinkConsistentMap = (ConsistentMap)((ConsistentMapBuilder)((ConsistentMapBuilder)((ConsistentMapBuilder)this.storageService.consistentMapBuilder().withSerializer(TETOPOLOGY_SERIALIZER)).withName(TELINKGLOBALKEY_INTERNALTELINK)).withRelaxedReadConsistency()).build();
        this.teLinkConsistentMap.addListener(this.teLinkListener);
        this.teLinkMap = this.teLinkConsistentMap.asJavaMap();
        this.networkLinkConsistentMap = (ConsistentMap)((ConsistentMapBuilder)((ConsistentMapBuilder)((ConsistentMapBuilder)this.storageService.consistentMapBuilder().withSerializer(TETOPOLOGY_SERIALIZER)).withName(NETWORKLINKKEY_INTERNALNETWORKLINK)).withRelaxedReadConsistency()).build();
        this.networkLinkConsistentMap.addListener(this.networkLinkListener);
        this.networkLinkMap = this.networkLinkConsistentMap.asJavaMap();
        this.tpConsistentMap = (ConsistentMap)((ConsistentMapBuilder)((ConsistentMapBuilder)((ConsistentMapBuilder)this.storageService.consistentMapBuilder().withSerializer(TETOPOLOGY_SERIALIZER)).withName(TPKEY_INTERNALTERMINATIONPOINT)).withRelaxedReadConsistency()).build();
        this.tpMap = this.tpConsistentMap.asJavaMap();
        this.tpKeyConsistentMap = (ConsistentMap)((ConsistentMapBuilder)((ConsistentMapBuilder)((ConsistentMapBuilder)this.storageService.consistentMapBuilder().withSerializer(TETOPOLOGY_SERIALIZER)).withName(TELINKTPGLOBALKEY_TERMINATIONPOINTKEY)).withRelaxedReadConsistency()).build();
        this.tpKeyMap = this.tpKeyConsistentMap.asJavaMap();
        this.ttpConsistentMap = (ConsistentMap)((ConsistentMapBuilder)((ConsistentMapBuilder)((ConsistentMapBuilder)this.storageService.consistentMapBuilder().withSerializer(TETOPOLOGY_SERIALIZER)).withName(TTPKEY_TUNNELTERMINATIONPOINT)).withRelaxedReadConsistency()).build();
        this.ttpMap = this.ttpConsistentMap.asJavaMap();
        this.nextTeTopologyId = this.storageService.getAtomicCounter("COUNTER_NAME");
        this.log.info("Started");
    }

    @Deactivate
    public void deactivate() {
        this.teTopologyConsistentMap.removeListener(this.teTopologyListener);
        this.teTopologyConsistentMap.destroy();
        this.teTopologyMap.clear();
        this.networkConsistentMap.removeListener(this.networkListener);
        this.networkConsistentMap.destroy();
        this.networkMap.clear();
        this.teNodeConsistentMap.removeListener(this.teNodeListener);
        this.teNodeConsistentMap.destroy();
        this.teNodeMap.clear();
        this.connMatrixConsistentMap.destroy();
        this.connMatrixMap.clear();
        this.networkNodeConsistentMap.destroy();
        this.networkNodeConsistentMap.removeListener(this.networkNodeListener);
        this.networkNodeMap.clear();
        this.teLinkConsistentMap.removeListener(this.teLinkListener);
        this.teLinkConsistentMap.destroy();
        this.teLinkMap.clear();
        this.networkLinkConsistentMap.destroy();
        this.networkLinkConsistentMap.removeListener(this.networkLinkListener);
        this.networkLinkMap.clear();
        this.tpConsistentMap.destroy();
        this.tpMap.clear();
        this.tpKeyConsistentMap.destroy();
        this.tpKeyMap.clear();
        this.ttpConsistentMap.destroy();
        this.ttpMap.clear();
        this.mapEventQueue.clear();
        this.log.info("Stopped");
    }

    @Override
    public TeTopologies teTopologies() {
        HashMap teTopologies = Maps.newHashMap();
        if (MapUtils.isNotEmpty(this.teTopologyMap)) {
            for (TeTopologyKey key : this.teTopologyMap.keySet()) {
                teTopologies.put(key, this.teTopology(key));
            }
        }
        return new DefaultTeTopologies(STORE_NAME, (Map)teTopologies);
    }

    private TeTopology teTopology(TeTopologyKey topologyId, InternalTeTopology intTopology) {
        if (intTopology == null) {
            return null;
        }
        HashMap teNodes = null;
        if (CollectionUtils.isNotEmpty(intTopology.teNodeKeys())) {
            teNodes = Maps.newHashMap();
            for (TeNodeKey key : intTopology.teNodeKeys()) {
                teNodes.put(key.teNodeId(), this.teNode(key));
            }
        }
        HashMap teLinks = null;
        if (CollectionUtils.isNotEmpty(intTopology.teLinkKeys())) {
            teLinks = Maps.newHashMap();
            for (TeLinkTpGlobalKey key : intTopology.teLinkKeys()) {
                teLinks.put(key.teLinkTpKey(), this.teLink(key));
            }
        }
        return new DefaultTeTopology(topologyId, (Map)teNodes, (Map)teLinks, intTopology.teTopologyId(), intTopology.topologyData());
    }

    @Override
    public TeTopology teTopology(TeTopologyKey topologyId) {
        InternalTeTopology intTopology = this.teTopologyMap.get(topologyId);
        return this.teTopology(topologyId, intTopology);
    }

    private void removeTopologyeMapEntrys(InternalTeTopology curTopology) {
        if (CollectionUtils.isNotEmpty(curTopology.teNodeKeys())) {
            for (TeNodeKey teNodeKey : curTopology.teNodeKeys()) {
                this.removeTeNode(teNodeKey, true);
            }
        }
        if (CollectionUtils.isNotEmpty(curTopology.teLinkKeys())) {
            for (TeLinkTpGlobalKey teLinkTpGlobalKey : curTopology.teLinkKeys()) {
                this.removeTeLink(teLinkTpGlobalKey, true);
            }
        }
    }

    @Override
    public void updateTeTopology(TeTopology teTopology) {
        InternalTeTopology curTopology = this.teTopologyMap.get(teTopology.teTopologyId());
        ArrayList nodeIds = null;
        if (MapUtils.isNotEmpty((Map)teTopology.teNodes())) {
            nodeIds = Lists.newArrayList();
            for (Map.Entry entry : teTopology.teNodes().entrySet()) {
                TeNodeKey teNodeKey = new TeNodeKey(teTopology.teTopologyId(), ((Long)entry.getKey()).longValue());
                NetworkNodeKey nodeKey = TeMgrUtil.networkNodeKey(teNodeKey);
                this.updateTeNode(teNodeKey, (TeNode)entry.getValue(), true, true, nodeKey);
                nodeIds.add(nodeKey);
            }
        }
        ArrayList linkIds = null;
        if (MapUtils.isNotEmpty((Map)teTopology.teLinks())) {
            linkIds = Lists.newArrayList();
            for (Map.Entry entry : teTopology.teLinks().entrySet()) {
                TeLinkTpGlobalKey teLinkKey = new TeLinkTpGlobalKey(teTopology.teTopologyId(), (TeLinkTpKey)entry.getKey());
                NetworkLinkKey linkKey = TeMgrUtil.networkLinkKey(teLinkKey);
                this.updateTeLink(teLinkKey, (TeLink)entry.getValue(), true, true, linkKey);
                linkIds.add(linkKey);
            }
        }
        InternalTeTopology internalTeTopology = new InternalTeTopology(teTopology);
        this.teTopologyMap.put(teTopology.teTopologyId(), internalTeTopology);
        if (curTopology == null) {
            InternalNetwork internalNetwork = new InternalNetwork();
            internalNetwork.setServerProvided(false);
            internalNetwork.setTeTopologyKey(teTopology.teTopologyId());
            internalNetwork.setNodeIds(nodeIds);
            internalNetwork.setLinkIds(linkIds);
            this.networkMap.put(teTopology.networkId(), internalNetwork);
        }
    }

    @Override
    public void removeTeTopology(TeTopologyKey topologyId) {
        InternalTeTopology topology = this.teTopologyMap.remove(topologyId);
        if (topology != null) {
            this.removeTopologyeMapEntrys(topology);
            this.networkMap.remove(topology.topologyData().networkId());
        }
    }

    @Override
    public List<Network> networks() {
        if (MapUtils.isEmpty(this.networkMap)) {
            return null;
        }
        ArrayList networks = Lists.newArrayList();
        for (KeyId networkId : this.networkMap.keySet()) {
            networks.add(this.network(networkId));
        }
        return networks;
    }

    private Network network(KeyId networkId, InternalNetwork curNetwork) {
        if (curNetwork == null) {
            return null;
        }
        List<KeyId> supportingNetworkIds = curNetwork.supportingNetworkIds();
        HashMap nodes = null;
        if (CollectionUtils.isNotEmpty(curNetwork.nodeIds())) {
            nodes = Maps.newHashMap();
            for (NetworkNodeKey key : curNetwork.nodeIds()) {
                nodes.put(key.nodeId(), this.networkNode(key));
            }
        }
        HashMap links = null;
        if (CollectionUtils.isNotEmpty(curNetwork.linkIds())) {
            links = Maps.newHashMap();
            for (NetworkLinkKey key : curNetwork.linkIds()) {
                links.put(key.linkId(), this.networkLink(key));
            }
        }
        TeTopologyId topologyId = null;
        DeviceId ownerId = null;
        if (curNetwork.teTopologyKey() != null && this.teTopologyMap.get(curNetwork.teTopologyKey()) != null) {
            topologyId = new TeTopologyId(curNetwork.teTopologyKey().providerId(), curNetwork.teTopologyKey().clientId(), this.teTopologyMap.get(curNetwork.teTopologyKey()).teTopologyId());
            ownerId = this.teTopologyMap.get(curNetwork.teTopologyKey()).topologyData().ownerId();
        }
        return new DefaultNetwork(networkId, supportingNetworkIds, (Map)nodes, (Map)links, topologyId, curNetwork.serverProvided(), ownerId);
    }

    @Override
    public Network network(KeyId networkId) {
        InternalNetwork curNetwork = this.networkMap.get(networkId);
        return this.network(networkId, curNetwork);
    }

    private void removeNetworkMapEntrys(InternalNetwork curNetwork, boolean teRemove) {
        if (CollectionUtils.isNotEmpty(curNetwork.nodeIds())) {
            for (NetworkNodeKey networkNodeKey : curNetwork.nodeIds()) {
                this.removeNetworkNode(networkNodeKey, teRemove);
            }
        }
        if (CollectionUtils.isNotEmpty(curNetwork.linkIds())) {
            for (NetworkLinkKey networkLinkKey : curNetwork.linkIds()) {
                this.removeNetworkLink(networkLinkKey, teRemove);
            }
        }
    }

    private TeTopologyKey newTeTopologyKey(TeTopologyId teTopologyId) {
        long idValue;
        try {
            idValue = Long.parseLong(teTopologyId.topologyId());
        }
        catch (NumberFormatException e) {
            idValue = this.nextTeTopologyId();
        }
        return new TeTopologyKey(teTopologyId.providerId(), teTopologyId.clientId(), idValue);
    }

    @Override
    public void updateNetwork(Network network) {
        this.log.debug("updateNetwork {}", (Object)network);
        InternalNetwork curNetwork = this.networkMap.get(network.networkId());
        TeTopologyKey topoKey = null;
        if (network.teTopologyId() != null) {
            topoKey = this.newTeTopologyKey(network.teTopologyId());
        }
        ArrayList teNodeKeys = null;
        if (MapUtils.isNotEmpty((Map)network.nodes())) {
            teNodeKeys = Lists.newArrayList();
            for (Map.Entry entry : network.nodes().entrySet()) {
                NetworkNodeKey networkNodeKey = new NetworkNodeKey(network.networkId(), (KeyId)entry.getKey());
                TeNodeKey teNodeKey = null;
                if (topoKey != null && ((NetworkNode)entry.getValue()).teNode() != null) {
                    teNodeKey = new TeNodeKey(topoKey, ((NetworkNode)entry.getValue()).teNode().teNodeId());
                }
                this.updateNetworkNode(networkNodeKey, (NetworkNode)entry.getValue(), true, false, teNodeKey);
                teNodeKeys.add(teNodeKey);
            }
        }
        ArrayList teLinkKeys = null;
        if (MapUtils.isNotEmpty((Map)network.links())) {
            teLinkKeys = Lists.newArrayList();
            for (Map.Entry entry : network.links().entrySet()) {
                NetworkLinkKey linkKey = new NetworkLinkKey(network.networkId(), (KeyId)entry.getKey());
                TeLinkTpGlobalKey teLinkKey = null;
                if (topoKey != null && ((NetworkLink)entry.getValue()).teLink() != null) {
                    teLinkKey = new TeLinkTpGlobalKey(topoKey, ((NetworkLink)entry.getValue()).teLink().teLinkKey());
                }
                this.updateNetworkLink(linkKey, (NetworkLink)entry.getValue(), true, false, teLinkKey);
                teLinkKeys.add(teLinkKey);
            }
        }
        if (curNetwork == null) {
            InternalTeTopology internalTeTopology = new InternalTeTopology(network.teTopologyId().topologyId());
            internalTeTopology.setTeNodeKeys(teNodeKeys);
            internalTeTopology.setTeLinkKeys(teLinkKeys);
            BitSet bitSet = new BitSet(16);
            bitSet.set(1);
            if (network.teTopologyId().clientId() == this.providerId) {
                bitSet.set(3);
            }
            CommonTopologyData common = new CommonTopologyData(network.networkId(), OptimizationType.NOT_OPTIMIZED, bitSet, network.ownerId());
            internalTeTopology.setTopologydata(common);
            this.teTopologyMap.put(topoKey, internalTeTopology);
        }
        InternalNetwork internalNetwork = new InternalNetwork(network);
        internalNetwork.setTeTopologyKey(topoKey);
        this.networkMap.put(network.networkId(), internalNetwork);
    }

    @Override
    public void removeNetwork(KeyId networkId) {
        InternalNetwork network = this.networkMap.remove(networkId);
        if (network != null && network.teTopologyKey() != null) {
            this.removeNetworkMapEntrys(network, false);
            this.teTopologyMap.remove(network.teTopologyKey());
        }
    }

    private TeNode teNode(TeNodeKey nodeKey, InternalTeNode intNode) {
        if (intNode == null) {
            return null;
        }
        HashMap connMatrices = null;
        if (CollectionUtils.isNotEmpty(intNode.connMatrixKeys())) {
            connMatrices = Maps.newHashMap();
            for (ConnectivityMatrixKey key : intNode.connMatrixKeys()) {
                connMatrices.put(key.entryId(), this.connMatrixMap.get(key));
            }
        }
        List teLinkIds = null;
        if (CollectionUtils.isNotEmpty(intNode.teLinkTpKeys())) {
            teLinkIds = Lists.newArrayList();
            for (TeLinkTpGlobalKey key : intNode.teLinkTpKeys()) {
                teLinkIds = TeUtils.addListElement((List)teLinkIds, (Object)key.teLinkTpId());
            }
        }
        List tps = null;
        if (CollectionUtils.isNotEmpty(intNode.teTpKeys())) {
            tps = Lists.newArrayList();
            for (TeLinkTpGlobalKey key : intNode.teTpKeys()) {
                tps = TeUtils.addListElement((List)tps, (Object)key.teLinkTpId());
            }
        }
        HashMap ttps = null;
        if (CollectionUtils.isNotEmpty(intNode.ttpKeys())) {
            ttps = Maps.newHashMap();
            for (TtpKey key : intNode.ttpKeys()) {
                ttps.put(key.ttpId(), this.ttpMap.get(key));
            }
        }
        return new DefaultTeNode(nodeKey.teNodeId(), intNode.underlayTopologyKey(), intNode.supportNodeKey(), intNode.sourceTeNodeKey(), intNode.teData(), (Map)connMatrices, teLinkIds, (Map)ttps, tps);
    }

    @Override
    public TeNode teNode(TeNodeKey nodeKey) {
        InternalTeNode intNode = this.teNodeMap.get(nodeKey);
        return this.teNode(nodeKey, intNode);
    }

    private void removeTeNodeMapEntrys(InternalTeNode intNode) {
        if (CollectionUtils.isNotEmpty(intNode.connMatrixKeys())) {
            for (ConnectivityMatrixKey connectivityMatrixKey : intNode.connMatrixKeys()) {
                this.connMatrixMap.remove(connectivityMatrixKey);
            }
        }
        if (CollectionUtils.isNotEmpty(intNode.ttpKeys())) {
            for (TtpKey ttpKey : intNode.ttpKeys()) {
                this.ttpMap.remove(ttpKey);
            }
        }
    }

    private void updateTeNode(TeNodeKey nodeKey, TeNode node, boolean parentUpdate, boolean teNodeUpdate, NetworkNodeKey networkNodeKey) {
        InternalTeTopology intTopo = this.teTopologyMap.get(nodeKey.teTopologyKey());
        if (intTopo == null && !parentUpdate) {
            this.log.error("TE Topology is not in dataStore for nodeUpdate {}", (Object)nodeKey);
            return;
        }
        InternalTeNode curNode = this.teNodeMap.get(nodeKey);
        if (MapUtils.isNotEmpty((Map)node.connectivityMatrices())) {
            for (Map.Entry entry : node.connectivityMatrices().entrySet()) {
                this.connMatrixMap.put(new ConnectivityMatrixKey(nodeKey, ((Long)entry.getKey()).longValue()), (ConnectivityMatrix)entry.getValue());
            }
        }
        if (MapUtils.isNotEmpty((Map)node.tunnelTerminationPoints())) {
            for (Map.Entry entry : node.tunnelTerminationPoints().entrySet()) {
                this.ttpMap.put(new TtpKey(nodeKey, ((Long)entry.getKey()).longValue()), (TunnelTerminationPoint)entry.getValue());
            }
        }
        InternalTeNode intNode = new InternalTeNode(nodeKey, node, networkNodeKey, parentUpdate);
        this.teNodeMap.put(nodeKey, intNode);
        if (curNode == null && !parentUpdate && intTopo != null) {
            intTopo.setChildUpdate(true);
            TeUtils.addListElement(intTopo.teNodeKeys(), (Object)nodeKey);
        }
        if (teNodeUpdate) {
            this.updateNetworkNode(networkNodeKey, this.networkNode(node), parentUpdate, teNodeUpdate, nodeKey);
        }
    }

    private NetworkNode networkNode(TeNode node) {
        KeyId nodeId = KeyId.keyId((String)Long.toString(node.teNodeId()));
        ArrayList supportingNodeIds = null;
        if (node.supportingTeNodeId() != null) {
            supportingNodeIds = Lists.newArrayList();
            supportingNodeIds.add(new NetworkNodeKey(TeMgrUtil.toNetworkId(node.supportingTeNodeId().teTopologyKey()), KeyId.keyId((String)Long.toString(node.supportingTeNodeId().teNodeId()))));
        }
        HashMap tps = null;
        if (node.teTerminationPointIds() != null) {
            tps = Maps.newHashMap();
            for (Long teTpId : node.teTerminationPointIds()) {
                tps.put(KeyId.keyId((String)Long.toString(teTpId)), new DefaultTerminationPoint(KeyId.keyId((String)Long.toString(teTpId)), null, teTpId));
            }
        }
        return new DefaultNetworkNode(nodeId, (List)supportingNodeIds, node, (Map)tps);
    }

    @Override
    public void updateTeNode(TeNodeKey nodeKey, TeNode node) {
        this.updateTeNode(nodeKey, node, false, true, TeMgrUtil.networkNodeKey(nodeKey));
    }

    private void removeTeNode(TeNodeKey nodeKey, boolean teNodeRemove) {
        InternalTeNode node;
        InternalTeTopology intTopo = this.teTopologyMap.get(nodeKey.teTopologyKey());
        if (intTopo != null && CollectionUtils.isNotEmpty(intTopo.teNodeKeys())) {
            intTopo.setChildUpdate(true);
            intTopo.teNodeKeys().remove(nodeKey);
        }
        if ((node = this.teNodeMap.remove(nodeKey)) == null) {
            this.log.error("No node found for nodeKey {}", (Object)nodeKey);
            return;
        }
        this.removeTeNodeMapEntrys(node);
        if (teNodeRemove && node != null) {
            this.removeNetworkNode(node.networkNodeKey(), teNodeRemove);
        }
    }

    @Override
    public void removeTeNode(TeNodeKey nodeKey) {
        this.removeTeNode(nodeKey, true);
    }

    private NetworkNode networkNode(NetworkNodeKey nodeKey, InternalNetworkNode intNode) {
        if (intNode == null) {
            return null;
        }
        HashMap tps = Maps.newHashMap();
        for (KeyId tpId : intNode.tpIds()) {
            tps.put(tpId, this.terminationPoint(new TerminationPointKey(nodeKey, tpId)));
        }
        return new DefaultNetworkNode(nodeKey.nodeId(), intNode.supportingNodeIds(), this.teNode(intNode.teNodeKey()), (Map)tps);
    }

    @Override
    public NetworkNode networkNode(NetworkNodeKey nodeKey) {
        InternalNetworkNode intNode = this.networkNodeMap.get(nodeKey);
        return this.networkNode(nodeKey, intNode);
    }

    private void updateNetworkNode(NetworkNodeKey nodeKey, NetworkNode node, boolean parentUpdate, boolean teNodeUpdate, TeNodeKey teNodeKey) {
        InternalNetwork intNework = null;
        if (!parentUpdate && (intNework = this.networkMap.get(nodeKey.networkId())) == null) {
            this.log.error("Network is not in dataStore for nodeUpdate {}", (Object)nodeKey);
            return;
        }
        InternalNetworkNode exNode = this.networkNodeMap.get(nodeKey);
        if (exNode != null && CollectionUtils.isNotEmpty(exNode.tpIds())) {
            for (KeyId keyId : exNode.tpIds()) {
                this.removeTerminationPoint(new TerminationPointKey(nodeKey, keyId));
            }
        }
        if (MapUtils.isNotEmpty((Map)node.terminationPoints())) {
            for (Map.Entry entry : node.terminationPoints().entrySet()) {
                this.updateTerminationPoint(new TerminationPointKey(nodeKey, (KeyId)entry.getKey()), (TerminationPoint)entry.getValue(), parentUpdate, teNodeKey);
            }
        }
        if (!teNodeUpdate && teNodeKey != null && node.teNode() != null) {
            this.updateTeNode(teNodeKey, node.teNode(), parentUpdate, teNodeUpdate, nodeKey);
        }
        InternalNetworkNode intNode = new InternalNetworkNode(node, parentUpdate);
        intNode.setTeNodeKey(teNodeKey);
        this.networkNodeMap.put(nodeKey, intNode);
        if (exNode == null && !parentUpdate && intNework != null) {
            intNework.setChildUpdate(true);
            TeUtils.addListElement(intNework.nodeIds(), (Object)nodeKey);
        }
    }

    @Override
    public void updateNetworkNode(NetworkNodeKey nodeKey, NetworkNode node) {
        TeNodeKey teNodeKey = null;
        if (node.teNode() != null) {
            teNodeKey = new TeNodeKey(this.networkMap.get(nodeKey.networkId()).teTopologyKey(), node.teNode().teNodeId());
        }
        this.updateNetworkNode(nodeKey, node, false, false, teNodeKey);
    }

    private void removeNetworkNode(NetworkNodeKey nodeKey, boolean teNodeRemove) {
        InternalNetworkNode intNode;
        InternalNetwork intNework = this.networkMap.get(nodeKey.networkId());
        if (intNework != null && CollectionUtils.isNotEmpty(intNework.nodeIds())) {
            intNework.setChildUpdate(true);
            intNework.nodeIds().remove(nodeKey.nodeId());
        }
        if ((intNode = this.networkNodeMap.remove(nodeKey)) != null && CollectionUtils.isNotEmpty(intNode.tpIds())) {
            for (KeyId tpId : intNode.tpIds()) {
                this.removeTerminationPoint(new TerminationPointKey(nodeKey, tpId));
            }
        }
        if (!teNodeRemove && intNode != null) {
            this.removeTeNode(intNode.teNodeKey(), teNodeRemove);
        }
    }

    @Override
    public void removeNetworkNode(NetworkNodeKey nodeKey) {
        this.removeNetworkNode(nodeKey, false);
    }

    private TeLink teLink(TeLinkTpGlobalKey linkKey, InternalTeLink intLink) {
        if (intLink == null) {
            return null;
        }
        return new DefaultTeLink(linkKey.teLinkTpKey(), intLink.peerTeLinkKey(), intLink.underlayTopologyKey(), intLink.supportingLinkKey(), intLink.sourceTeLinkKey(), intLink.teData());
    }

    @Override
    public TeLink teLink(TeLinkTpGlobalKey linkKey) {
        InternalTeLink intLink = this.teLinkMap.get(linkKey);
        return this.teLink(linkKey, intLink);
    }

    private void updateTeLink(TeLinkTpGlobalKey linkKey, TeLink link, boolean parentUpdate, boolean teLinkUpdate, NetworkLinkKey networkLinkKey) {
        InternalTeTopology intTopo = this.teTopologyMap.get(linkKey.teTopologyKey());
        if (intTopo == null && !parentUpdate) {
            this.log.error("TE Topology is not in dataStore for linkUpdate {}", (Object)linkKey);
            return;
        }
        InternalTeNode intNode = this.teNodeMap.get(linkKey.teNodeKey());
        if (intNode == null && !parentUpdate) {
            this.log.error("TE node is not in dataStore for linkUpdate {}", (Object)linkKey);
            return;
        }
        InternalTeLink exLink = this.teLinkMap.get(linkKey);
        InternalTeLink intLink = new InternalTeLink(link, parentUpdate);
        intLink.setNetworkLinkKey(networkLinkKey);
        this.teLinkMap.put(linkKey, intLink);
        if (exLink == null && !parentUpdate) {
            if (intTopo != null) {
                intTopo.setChildUpdate(true);
                intTopo.setTeLinkKeys(TeUtils.addListElement(intTopo.teLinkKeys(), (Object)linkKey));
            }
            if (intNode != null) {
                intNode.setChildUpdate(true);
                intNode.setTeLinkTpKeys(TeUtils.addListElement(intNode.teLinkTpKeys(), (Object)linkKey));
            }
        }
        if (teLinkUpdate) {
            this.updateNetworkLink(networkLinkKey, this.networkLink(link), parentUpdate, teLinkUpdate, linkKey);
        }
    }

    private NetworkLink networkLink(TeLink link) {
        KeyId linkId = TeMgrUtil.toNetworkLinkId(link.teLinkKey());
        NodeTpKey source = null;
        if (link.teLinkKey() != null) {
            source = new NodeTpKey(KeyId.keyId((String)Long.toString(link.teLinkKey().teNodeId())), KeyId.keyId((String)Long.toString(link.teLinkKey().teLinkTpId())));
        }
        NodeTpKey dest = null;
        if (link.peerTeLinkKey() != null) {
            dest = new NodeTpKey(KeyId.keyId((String)Long.toString(link.peerTeLinkKey().teNodeId())), KeyId.keyId((String)Long.toString(link.peerTeLinkKey().teLinkTpId())));
        }
        ArrayList supportingLinkIds = null;
        if (link.supportingTeLinkId() != null) {
            supportingLinkIds = Lists.newArrayList();
            supportingLinkIds.add(new NetworkLinkKey(TeMgrUtil.toNetworkId(link.supportingTeLinkId().teTopologyKey()), TeMgrUtil.toNetworkLinkId(link.supportingTeLinkId().teLinkTpKey())));
        }
        return new DefaultNetworkLink(linkId, source, dest, (List)supportingLinkIds, link);
    }

    @Override
    public void updateTeLink(TeLinkTpGlobalKey linkKey, TeLink link) {
        this.updateTeLink(linkKey, link, false, true, TeMgrUtil.networkLinkKey(linkKey));
    }

    private void removeTeLink(TeLinkTpGlobalKey linkKey, boolean teLinkRemove) {
        InternalTeNode intNode;
        InternalTeTopology intTopo = this.teTopologyMap.get(linkKey.teTopologyKey());
        if (intTopo != null && CollectionUtils.isNotEmpty(intTopo.teLinkKeys())) {
            intTopo.setChildUpdate(true);
            intTopo.teLinkKeys().remove(linkKey);
        }
        if ((intNode = this.teNodeMap.get(linkKey.teNodeKey())) != null && CollectionUtils.isNotEmpty(intNode.teLinkTpKeys())) {
            intNode.setChildUpdate(true);
            intNode.teLinkTpKeys().remove(linkKey);
        }
        InternalTeLink link = this.teLinkMap.remove(linkKey);
        if (teLinkRemove && link != null) {
            this.removeNetworkLink(link.networkLinkKey(), teLinkRemove);
        }
    }

    @Override
    public void removeTeLink(TeLinkTpGlobalKey linkKey) {
        this.removeTeLink(linkKey, true);
    }

    private NetworkLink networkLink(NetworkLinkKey linkKey, InternalNetworkLink intLink) {
        if (intLink == null) {
            return null;
        }
        return new DefaultNetworkLink(linkKey.linkId(), intLink.source(), intLink.destination(), intLink.supportingLinkIds(), this.teLink(intLink.teLinkKey()));
    }

    @Override
    public NetworkLink networkLink(NetworkLinkKey linkKey) {
        InternalNetworkLink intLink = this.networkLinkMap.get(linkKey);
        return this.networkLink(linkKey, intLink);
    }

    private void updateNetworkLink(NetworkLinkKey linkKey, NetworkLink link, boolean parentUpdate, boolean teLinkUpdate, TeLinkTpGlobalKey teLinkKey) {
        InternalNetwork intNework = null;
        if (!parentUpdate && (intNework = this.networkMap.get(linkKey.networkId())) == null) {
            this.log.error("Network is not in dataStore for linkUpdate {}", (Object)linkKey);
            return;
        }
        InternalNetworkLink exLink = this.networkLinkMap.get(linkKey);
        if (!teLinkUpdate && teLinkKey != null) {
            this.updateTeLink(teLinkKey, link.teLink(), parentUpdate, teLinkUpdate, linkKey);
        }
        InternalNetworkLink intLink = new InternalNetworkLink(link, parentUpdate);
        intLink.setTeLinkKey(teLinkKey);
        this.networkLinkMap.put(linkKey, intLink);
        if (exLink == null && !parentUpdate && intNework != null) {
            intNework.setChildUpdate(true);
            TeUtils.addListElement(intNework.linkIds(), (Object)linkKey);
        }
    }

    @Override
    public void updateNetworkLink(NetworkLinkKey linkKey, NetworkLink link) {
        TeLinkTpGlobalKey teLinkKey = null;
        if (link.teLink() != null) {
            teLinkKey = new TeLinkTpGlobalKey(this.networkMap.get(linkKey.networkId()).teTopologyKey(), link.teLink().teLinkKey());
        }
        this.updateNetworkLink(linkKey, link, false, false, teLinkKey);
    }

    private void removeNetworkLink(NetworkLinkKey linkKey, boolean teLinkRemove) {
        InternalNetwork intNework = this.networkMap.get(linkKey.networkId());
        if (intNework != null && CollectionUtils.isNotEmpty(intNework.linkIds())) {
            intNework.setChildUpdate(true);
            intNework.linkIds().remove(linkKey.linkId());
        }
        InternalNetworkLink intLink = this.networkLinkMap.remove(linkKey);
        if (!teLinkRemove && intLink != null && intLink.teLinkKey() != null) {
            this.removeTeLink(intLink.teLinkKey(), teLinkRemove);
        }
    }

    @Override
    public void removeNetworkLink(NetworkLinkKey linkKey) {
        this.removeNetworkLink(linkKey, false);
    }

    private TerminationPoint terminationPoint(TerminationPointKey tpKey) {
        InternalTerminationPoint intTp = this.tpMap.get(tpKey);
        if (intTp == null) {
            return null;
        }
        return new DefaultTerminationPoint(tpKey.tpId(), intTp.supportingTpIds(), Long.valueOf(intTp.teTpKey().teLinkTpId()));
    }

    private void updateTerminationPoint(TerminationPointKey tpKey, TerminationPoint tp, boolean parentUpdate, TeNodeKey teNodeKey) {
        TeNodeKey myTeNodeKey;
        InternalNetworkNode intNode = null;
        if (!parentUpdate) {
            intNode = this.networkNodeMap.get(tpKey.nodeId());
            if (intNode == null) {
                this.log.error(" node is not in dataStore for tp update {}", (Object)tpKey);
                return;
            }
            myTeNodeKey = intNode.teNodeKey();
        } else {
            myTeNodeKey = teNodeKey;
        }
        TeLinkTpGlobalKey teTpKey = new TeLinkTpGlobalKey(myTeNodeKey, tp.teTpId().longValue());
        boolean newTp = this.tpMap.get(tpKey) == null;
        InternalTerminationPoint intTp = new InternalTerminationPoint(tp);
        intTp.setTeTpKey(teTpKey);
        this.tpMap.put(tpKey, intTp);
        if (newTp) {
            this.tpKeyMap.put(teTpKey, tpKey);
            if (!parentUpdate && intNode != null) {
                intNode.setChildUpdate(true);
                intNode.setTpIds(TeUtils.addListElement(intNode.tpIds(), (Object)tpKey.tpId()));
            }
        }
    }

    @Override
    public void updateTerminationPoint(TerminationPointKey tpKey, TerminationPoint tp) {
        this.updateTerminationPoint(tpKey, tp, false, null);
    }

    @Override
    public void removeTerminationPoint(TerminationPointKey tpKey) {
        InternalTerminationPoint tp;
        InternalNetworkNode intNode = this.networkNodeMap.get(tpKey.nodeId());
        if (intNode != null && CollectionUtils.isNotEmpty(intNode.tpIds())) {
            intNode.setChildUpdate(true);
            intNode.tpIds().remove(tpKey.tpId());
        }
        if ((tp = this.tpMap.remove(tpKey)) != null) {
            this.tpKeyMap.remove(tp.teTpKey());
        }
    }

    @Override
    public TunnelTerminationPoint tunnelTerminationPoint(TtpKey ttpId) {
        return this.ttpMap.get(ttpId);
    }

    @Override
    public long nextTeTopologyId() {
        return this.nextTeTopologyId.getAndIncrement();
    }

    @Override
    public long nextTeNodeId(TeTopologyKey topoKey) {
        return this.teTopologyMap.get(topoKey).nextTeNodeId();
    }

    @Override
    public void setNextTeNodeId(TeTopologyKey topoKey, long nextNodeId) {
        this.teTopologyMap.get(topoKey).setNextTeNodeId(nextNodeId);
    }

    @Override
    public KeyId networkId(TeTopologyKey teTopologyKey) {
        return this.teTopologyMap.get(teTopologyKey) == null || this.teTopologyMap.get(teTopologyKey).topologyData() == null ? null : this.teTopologyMap.get(teTopologyKey).topologyData().networkId();
    }

    @Override
    public NetworkNodeKey nodeKey(TeNodeKey teNodeKey) {
        return this.teNodeMap.get(teNodeKey) == null ? null : this.teNodeMap.get(teNodeKey).networkNodeKey();
    }

    @Override
    public NetworkLinkKey linkKey(TeLinkTpGlobalKey teLinkKey) {
        return this.teLinkMap.get(teLinkKey) == null ? null : this.teLinkMap.get(teLinkKey).networkLinkKey();
    }

    @Override
    public TerminationPointKey terminationPointKey(TeLinkTpGlobalKey teTpKey) {
        return this.tpKeyMap.get(teTpKey);
    }

    @Override
    public BlockingQueue<TeTopologyMapEvent> mapEventQueue() {
        return this.mapEventQueue;
    }

    @Override
    public void setProviderId(long providerId) {
        this.providerId = providerId;
    }

    protected void bindStorageService(StorageService storageService) {
        this.storageService = storageService;
    }

    protected void unbindStorageService(StorageService storageService) {
        if (this.storageService == storageService) {
            this.storageService = null;
        }
    }

    private class InternalNetworkLinkListener
    implements MapEventListener<NetworkLinkKey, InternalNetworkLink> {
        private InternalNetworkLinkListener() {
        }

        public void event(MapEvent<NetworkLinkKey, InternalNetworkLink> event) {
            TeTopologyEvent.Type type = null;
            switch (event.type()) {
                case INSERT: {
                    if (((InternalNetworkLink)event.newValue().value()).parentUpdate()) break;
                    type = TeTopologyEvent.Type.LINK_ADDED;
                    break;
                }
                case UPDATE: {
                    if (((InternalNetworkLink)event.newValue().value()).parentUpdate()) break;
                    type = TeTopologyEvent.Type.LINK_UPDATED;
                    break;
                }
                case REMOVE: {
                    type = TeTopologyEvent.Type.LINK_REMOVED;
                    break;
                }
                default: {
                    DistributedTeTopologyStore.this.log.error("Unsupported event type: {}", (Object)event.type());
                }
            }
            if (type != null) {
                TeTopologyMapEvent mapEvent = new TeTopologyMapEvent(type);
                mapEvent.setNetworkLinkKey((NetworkLinkKey)event.key());
                try {
                    DistributedTeTopologyStore.this.mapEventQueue.put(mapEvent);
                }
                catch (InterruptedException e) {
                    DistributedTeTopologyStore.this.log.warn("Unable to queue event {} ", (Object)mapEvent, (Object)e);
                }
            }
        }
    }

    private class InternalTeLinkListener
    implements MapEventListener<TeLinkTpGlobalKey, InternalTeLink> {
        private InternalTeLinkListener() {
        }

        public void event(MapEvent<TeLinkTpGlobalKey, InternalTeLink> event) {
            TeTopologyEvent.Type type = null;
            switch (event.type()) {
                case INSERT: {
                    if (((InternalTeLink)event.newValue().value()).parentUpdate()) break;
                    type = TeTopologyEvent.Type.TE_LINK_ADDED;
                    break;
                }
                case UPDATE: {
                    if (((InternalTeLink)event.newValue().value()).parentUpdate()) break;
                    type = TeTopologyEvent.Type.TE_LINK_UPDATED;
                    break;
                }
                case REMOVE: {
                    type = TeTopologyEvent.Type.TE_LINK_REMOVED;
                    break;
                }
                default: {
                    DistributedTeTopologyStore.this.log.error("Unsupported event type: {}", (Object)event.type());
                }
            }
            if (type != null) {
                TeTopologyMapEvent mapEvent = new TeTopologyMapEvent(type);
                mapEvent.setTeLinkKey((TeLinkTpGlobalKey)event.key());
                try {
                    DistributedTeTopologyStore.this.mapEventQueue.put(mapEvent);
                }
                catch (InterruptedException e) {
                    DistributedTeTopologyStore.this.log.warn("Unable to queue event {} ", (Object)mapEvent, (Object)e);
                }
            }
        }
    }

    private class InternalNetworkNodeListener
    implements MapEventListener<NetworkNodeKey, InternalNetworkNode> {
        private InternalNetworkNodeListener() {
        }

        public void event(MapEvent<NetworkNodeKey, InternalNetworkNode> event) {
            TeTopologyEvent.Type type = null;
            switch (event.type()) {
                case INSERT: {
                    if (((InternalNetworkNode)event.newValue().value()).parentUpdate()) break;
                    type = TeTopologyEvent.Type.NODE_ADDED;
                    break;
                }
                case UPDATE: {
                    if (((InternalNetworkNode)event.newValue().value()).childUpdate() || ((InternalNetworkNode)event.newValue().value()).parentUpdate()) break;
                    type = TeTopologyEvent.Type.NODE_UPDATED;
                    break;
                }
                case REMOVE: {
                    type = TeTopologyEvent.Type.NODE_REMOVED;
                    break;
                }
                default: {
                    DistributedTeTopologyStore.this.log.error("Unsupported event type: {}", (Object)event.type());
                }
            }
            if (type != null) {
                TeTopologyMapEvent mapEvent = new TeTopologyMapEvent(type);
                mapEvent.setNetworkNodeKey((NetworkNodeKey)event.key());
                try {
                    DistributedTeTopologyStore.this.mapEventQueue.put(mapEvent);
                }
                catch (InterruptedException e) {
                    DistributedTeTopologyStore.this.log.warn("Unable to queue event {} ", (Object)mapEvent, (Object)e);
                }
            }
        }
    }

    private class InternalTeNodeListener
    implements MapEventListener<TeNodeKey, InternalTeNode> {
        private InternalTeNodeListener() {
        }

        public void event(MapEvent<TeNodeKey, InternalTeNode> event) {
            TeTopologyEvent.Type type = null;
            switch (event.type()) {
                case INSERT: {
                    if (((InternalTeNode)event.newValue().value()).parentUpdate()) break;
                    type = TeTopologyEvent.Type.TE_NODE_ADDED;
                    break;
                }
                case UPDATE: {
                    if (((InternalTeNode)event.newValue().value()).childUpdate() || ((InternalTeNode)event.newValue().value()).parentUpdate()) break;
                    type = TeTopologyEvent.Type.TE_NODE_UPDATED;
                    break;
                }
                case REMOVE: {
                    type = TeTopologyEvent.Type.TE_NODE_REMOVED;
                    break;
                }
                default: {
                    DistributedTeTopologyStore.this.log.error("Unsupported event type: {}", (Object)event.type());
                }
            }
            if (type != null) {
                TeTopologyMapEvent mapEvent = new TeTopologyMapEvent(type);
                mapEvent.setTeNodeKey((TeNodeKey)event.key());
                try {
                    DistributedTeTopologyStore.this.mapEventQueue.put(mapEvent);
                }
                catch (InterruptedException e) {
                    DistributedTeTopologyStore.this.log.warn("Unable to queue event {} ", (Object)mapEvent, (Object)e);
                }
            }
        }
    }

    private class InternalNetworkListener
    implements MapEventListener<KeyId, InternalNetwork> {
        private InternalNetworkListener() {
        }

        public void event(MapEvent<KeyId, InternalNetwork> event) {
            TeTopologyEvent.Type type = null;
            switch (event.type()) {
                case INSERT: {
                    type = TeTopologyEvent.Type.NETWORK_ADDED;
                    break;
                }
                case UPDATE: {
                    if (((InternalNetwork)event.newValue().value()).childUpdate()) break;
                    type = TeTopologyEvent.Type.NETWORK_UPDATED;
                    break;
                }
                case REMOVE: {
                    type = TeTopologyEvent.Type.NETWORK_REMOVED;
                    break;
                }
                default: {
                    DistributedTeTopologyStore.this.log.error("Unsupported event type: {}", (Object)event.type());
                }
            }
            if (type != null) {
                TeTopologyMapEvent mapEvent = new TeTopologyMapEvent(type);
                mapEvent.setNetworkKey((KeyId)event.key());
                try {
                    DistributedTeTopologyStore.this.mapEventQueue.put(mapEvent);
                }
                catch (InterruptedException e) {
                    DistributedTeTopologyStore.this.log.warn("Unable to queue event {} ", (Object)mapEvent, (Object)e);
                }
            }
        }
    }

    private class InternalTeTopologyListener
    implements MapEventListener<TeTopologyKey, InternalTeTopology> {
        private InternalTeTopologyListener() {
        }

        public void event(MapEvent<TeTopologyKey, InternalTeTopology> event) {
            TeTopologyEvent.Type type = null;
            switch (event.type()) {
                case INSERT: {
                    type = TeTopologyEvent.Type.TE_TOPOLOGY_ADDED;
                    break;
                }
                case UPDATE: {
                    if (((InternalTeTopology)event.newValue().value()).childUpdate()) break;
                    type = TeTopologyEvent.Type.TE_TOPOLOGY_UPDATED;
                    break;
                }
                case REMOVE: {
                    type = TeTopologyEvent.Type.TE_TOPOLOGY_REMOVED;
                    break;
                }
                default: {
                    DistributedTeTopologyStore.this.log.error("Unsupported event type: {}", (Object)event.type());
                }
            }
            if (type != null) {
                TeTopologyMapEvent mapEvent = new TeTopologyMapEvent(type);
                mapEvent.setTeTopologyKey((TeTopologyKey)event.key());
                try {
                    DistributedTeTopologyStore.this.mapEventQueue.put(mapEvent);
                }
                catch (InterruptedException e) {
                    DistributedTeTopologyStore.this.log.warn("Unable to queue event {} ", (Object)mapEvent, (Object)e);
                }
            }
        }
    }
}

