/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.virtualbng;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.onlab.packet.IpAddress;
import org.onlab.packet.IpPrefix;
import org.onlab.packet.MacAddress;
import org.onosproject.net.ConnectPoint;
import org.onosproject.virtualbng.ConnectPointConfiguration;

public final class VbngConfiguration {
    private final List<IpPrefix> localPublicIpPrefixes;
    private final IpAddress nextHopIpAddress;
    private final MacAddress publicFacingMac;
    private final IpAddress xosIpAddress;
    private final int xosRestPort;
    private final Map<String, ConnectPointConfiguration> hosts;

    private VbngConfiguration() {
        this.localPublicIpPrefixes = null;
        this.nextHopIpAddress = null;
        this.publicFacingMac = null;
        this.xosIpAddress = null;
        this.xosRestPort = 0;
        this.hosts = null;
    }

    @JsonCreator
    public VbngConfiguration(@JsonProperty(value="localPublicIpPrefixes") List<IpPrefix> prefixes, @JsonProperty(value="nextHopIpAddress") IpAddress nextHopIpAddress, @JsonProperty(value="publicFacingMac") MacAddress publicFacingMac, @JsonProperty(value="xosIpAddress") IpAddress xosIpAddress, @JsonProperty(value="xosRestPort") int xosRestPort, @JsonProperty(value="hosts") Map<String, ConnectPointConfiguration> hosts) {
        this.localPublicIpPrefixes = prefixes;
        this.nextHopIpAddress = nextHopIpAddress;
        this.publicFacingMac = publicFacingMac;
        this.xosIpAddress = xosIpAddress;
        this.xosRestPort = xosRestPort;
        this.hosts = hosts;
    }

    public List<IpPrefix> getLocalPublicIpPrefixes() {
        return Collections.unmodifiableList(this.localPublicIpPrefixes);
    }

    public IpAddress getNextHopIpAddress() {
        return this.nextHopIpAddress;
    }

    public MacAddress getPublicFacingMac() {
        return this.publicFacingMac;
    }

    public IpAddress getXosIpAddress() {
        return this.xosIpAddress;
    }

    public int getXosRestPort() {
        return this.xosRestPort;
    }

    public Map<String, ConnectPoint> getHosts() {
        return this.hosts.entrySet().stream().collect(Collectors.toMap(e -> (String)e.getKey(), e -> ((ConnectPointConfiguration)e.getValue()).connectPoint()));
    }
}

