/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.provider.of.meter.util;

import com.google.common.base.Preconditions;
import com.google.common.collect.Sets;
import java.util.HashSet;
import java.util.Set;
import org.onosproject.net.DeviceId;
import org.onosproject.net.meter.Band;
import org.onosproject.net.meter.DefaultMeterFeatures;
import org.onosproject.net.meter.Meter;
import org.onosproject.net.meter.MeterFeatures;
import org.projectfloodlight.openflow.protocol.OFMeterFeatures;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MeterFeaturesBuilder {
    private static final Logger log = LoggerFactory.getLogger(MeterFeaturesBuilder.class);
    private final OFMeterFeatures ofMeterFeatures;
    private DeviceId deviceId;

    public MeterFeaturesBuilder(OFMeterFeatures features, DeviceId deviceId) {
        this.ofMeterFeatures = (OFMeterFeatures)Preconditions.checkNotNull((Object)features);
        this.deviceId = deviceId;
    }

    public MeterFeatures build() {
        MeterFeatures.Builder builder = DefaultMeterFeatures.builder().forDevice(this.deviceId).withMaxBands(this.ofMeterFeatures.getMaxBands()).withMaxColors(this.ofMeterFeatures.getMaxColor()).withMaxMeters(this.ofMeterFeatures.getMaxMeter());
        HashSet bands = Sets.newHashSet();
        if ((1L & this.ofMeterFeatures.getCapabilities()) != 0L) {
            bands.add(Band.Type.DROP);
        }
        if ((2L & this.ofMeterFeatures.getCapabilities()) != 0L) {
            bands.add(Band.Type.REMARK);
        }
        builder.withBandTypes((Set)bands);
        HashSet units = Sets.newHashSet();
        if ((2L & this.ofMeterFeatures.getCapabilities()) != 0L) {
            units.add(Meter.Unit.PKTS_PER_SEC);
        }
        if ((1L & this.ofMeterFeatures.getCapabilities()) != 0L) {
            units.add(Meter.Unit.KB_PER_SEC);
        }
        if (units.isEmpty()) {
            units.add(Meter.Unit.PKTS_PER_SEC);
        }
        builder.withUnits((Set)units);
        builder.hasBurst((4L & this.ofMeterFeatures.getCapabilities()) != 0L);
        builder.hasStats((8L & this.ofMeterFeatures.getCapabilities()) != 0L);
        return builder.build();
    }

    public static MeterFeatures noMeterFeatures(DeviceId deviceId) {
        return DefaultMeterFeatures.noMeterFeatures((DeviceId)deviceId);
    }
}

