/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.provider.of.meter.impl;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.RemovalCause;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Maps;
import java.net.URI;
import java.util.Collection;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import java.util.stream.Collectors;
import org.apache.felix.scr.annotations.Activate;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Deactivate;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.ReferenceCardinality;
import org.onosproject.core.CoreService;
import org.onosproject.net.Device;
import org.onosproject.net.DeviceId;
import org.onosproject.net.meter.Band;
import org.onosproject.net.meter.DefaultBand;
import org.onosproject.net.meter.DefaultMeter;
import org.onosproject.net.meter.Meter;
import org.onosproject.net.meter.MeterFailReason;
import org.onosproject.net.meter.MeterFeatures;
import org.onosproject.net.meter.MeterId;
import org.onosproject.net.meter.MeterOperation;
import org.onosproject.net.meter.MeterOperations;
import org.onosproject.net.meter.MeterProvider;
import org.onosproject.net.meter.MeterProviderRegistry;
import org.onosproject.net.meter.MeterProviderService;
import org.onosproject.net.meter.MeterState;
import org.onosproject.net.provider.AbstractProvider;
import org.onosproject.net.provider.Provider;
import org.onosproject.net.provider.ProviderId;
import org.onosproject.openflow.controller.Dpid;
import org.onosproject.openflow.controller.OpenFlowController;
import org.onosproject.openflow.controller.OpenFlowEventListener;
import org.onosproject.openflow.controller.OpenFlowSwitch;
import org.onosproject.openflow.controller.OpenFlowSwitchListener;
import org.onosproject.openflow.controller.RoleState;
import org.onosproject.provider.of.meter.impl.MeterModBuilder;
import org.onosproject.provider.of.meter.impl.MeterStatsCollector;
import org.onosproject.provider.of.meter.util.MeterFeaturesBuilder;
import org.projectfloodlight.openflow.protocol.OFErrorMsg;
import org.projectfloodlight.openflow.protocol.OFErrorType;
import org.projectfloodlight.openflow.protocol.OFMessage;
import org.projectfloodlight.openflow.protocol.OFMeterBandStats;
import org.projectfloodlight.openflow.protocol.OFMeterConfigStatsReply;
import org.projectfloodlight.openflow.protocol.OFMeterFeatures;
import org.projectfloodlight.openflow.protocol.OFMeterStats;
import org.projectfloodlight.openflow.protocol.OFMeterStatsReply;
import org.projectfloodlight.openflow.protocol.OFPortStatus;
import org.projectfloodlight.openflow.protocol.OFStatsReply;
import org.projectfloodlight.openflow.protocol.OFStatsType;
import org.projectfloodlight.openflow.protocol.OFVersion;
import org.projectfloodlight.openflow.protocol.errormsg.OFMeterModFailedErrorMsg;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(immediate=true, enabled=true)
public class OpenFlowMeterProvider
extends AbstractProvider
implements MeterProvider {
    private final Logger log = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected OpenFlowController controller;
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected MeterProviderRegistry providerRegistry;
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected CoreService coreService;
    private MeterProviderService providerService;
    private static final AtomicLong XID_COUNTER = new AtomicLong(1L);
    static final int POLL_INTERVAL = 10;
    static final long TIMEOUT = 30L;
    private Cache<Long, MeterOperation> pendingOperations;
    private InternalMeterListener listener = new InternalMeterListener();
    private Map<Dpid, MeterStatsCollector> collectors = Maps.newHashMap();
    private static final Set<Device.Type> NO_METER_SUPPORT = ImmutableSet.copyOf(EnumSet.of(Device.Type.ROADM, Device.Type.ROADM_OTN, Device.Type.FIBER_SWITCH, Device.Type.OTN));

    public OpenFlowMeterProvider() {
        super(new ProviderId("of", "org.onosproject.provider.meter"));
    }

    @Activate
    public void activate() {
        this.providerService = (MeterProviderService)this.providerRegistry.register((Provider)this);
        this.pendingOperations = CacheBuilder.newBuilder().expireAfterWrite(30L, TimeUnit.SECONDS).removalListener(notification -> {
            if (notification.getCause() == RemovalCause.EXPIRED) {
                this.providerService.meterOperationFailed((MeterOperation)notification.getValue(), MeterFailReason.TIMEOUT);
            }
        }).build();
        this.controller.addEventListener((OpenFlowEventListener)this.listener);
        this.controller.addListener((OpenFlowSwitchListener)this.listener);
        this.controller.getSwitches().forEach(sw -> this.createStatsCollection((OpenFlowSwitch)sw));
    }

    @Deactivate
    public void deactivate() {
        this.providerRegistry.unregister((Provider)this);
        this.collectors.values().forEach(MeterStatsCollector::stop);
        this.collectors.clear();
        this.controller.removeEventListener((OpenFlowEventListener)this.listener);
        this.controller.removeListener((OpenFlowSwitchListener)this.listener);
        this.providerService = null;
    }

    public void performMeterOperation(DeviceId deviceId, MeterOperations meterOps) {
        Dpid dpid = Dpid.dpid((URI)deviceId.uri());
        OpenFlowSwitch sw = this.controller.getSwitch(dpid);
        if (sw == null) {
            this.log.error("Unknown device {}", (Object)deviceId);
            meterOps.operations().forEach(op -> this.providerService.meterOperationFailed(op, MeterFailReason.UNKNOWN_DEVICE));
            return;
        }
        meterOps.operations().forEach(op -> this.performOperation(sw, (MeterOperation)op));
    }

    public void performMeterOperation(DeviceId deviceId, MeterOperation meterOp) {
        Dpid dpid = Dpid.dpid((URI)deviceId.uri());
        OpenFlowSwitch sw = this.controller.getSwitch(dpid);
        if (sw == null) {
            this.log.error("Unknown device {}", (Object)deviceId);
            this.providerService.meterOperationFailed(meterOp, MeterFailReason.UNKNOWN_DEVICE);
            return;
        }
        this.performOperation(sw, meterOp);
        if (meterOp.type().equals((Object)MeterOperation.Type.REMOVE)) {
            this.forceMeterStats(deviceId);
        }
    }

    private void forceMeterStats(DeviceId deviceId) {
        Dpid dpid = Dpid.dpid((URI)deviceId.uri());
        OpenFlowSwitch sw = this.controller.getSwitch(dpid);
        MeterStatsCollector once = new MeterStatsCollector(sw, 1);
        once.sendMeterStatistic();
    }

    private void performOperation(OpenFlowSwitch sw, MeterOperation op) {
        this.pendingOperations.put(op.meter().id().id(), (Object)op);
        Meter meter = op.meter();
        MeterModBuilder builder = MeterModBuilder.builder((Long)meter.id().id(), sw.factory());
        if (meter.isBurst()) {
            builder.burst();
        }
        builder.withBands(meter.bands()).withId(meter.id()).withRateUnit(meter.unit());
        switch (op.type()) {
            case ADD: {
                sw.sendMsg((OFMessage)builder.add());
                break;
            }
            case REMOVE: {
                sw.sendMsg((OFMessage)builder.remove());
                break;
            }
            case MODIFY: {
                sw.sendMsg((OFMessage)builder.modify());
                break;
            }
            default: {
                this.log.warn("Unknown Meter command {}; not sending anything", (Object)op.type());
                this.providerService.meterOperationFailed(op, MeterFailReason.UNKNOWN_COMMAND);
            }
        }
    }

    private void createStatsCollection(OpenFlowSwitch sw) {
        if (sw != null && this.isMeterSupported(sw)) {
            MeterStatsCollector msc = new MeterStatsCollector(sw, 10);
            msc.start();
            this.stopCollectorIfNeeded(this.collectors.put(new Dpid(sw.getId()), msc));
        }
    }

    private void stopCollectorIfNeeded(MeterStatsCollector collector) {
        if (collector != null) {
            collector.stop();
        }
    }

    private boolean isMeterSupported(OpenFlowSwitch sw) {
        return sw.factory().getVersion() != OFVersion.OF_10 && sw.factory().getVersion() != OFVersion.OF_11 && sw.factory().getVersion() != OFVersion.OF_12 && !NO_METER_SUPPORT.contains(sw.deviceType()) && !sw.softwareDescription().equals("OF-DPA 2.0");
    }

    private void pushMeterStats(Dpid dpid, OFStatsReply msg) {
        DeviceId deviceId = DeviceId.deviceId((URI)Dpid.uri((Dpid)dpid));
        if (msg.getStatsType() == OFStatsType.METER) {
            OFMeterStatsReply reply = (OFMeterStatsReply)msg;
            Collection<Meter> meters = this.buildMeters(deviceId, reply.getEntries());
            this.providerService.pushMeterMetrics(deviceId, meters);
        } else if (msg.getStatsType() == OFStatsType.METER_CONFIG) {
            OFMeterConfigStatsReply oFMeterConfigStatsReply = (OFMeterConfigStatsReply)msg;
        }
    }

    private MeterFeatures buildMeterFeatures(Dpid dpid, OFMeterFeatures mf) {
        if (mf != null) {
            return new MeterFeaturesBuilder(mf, DeviceId.deviceId((URI)Dpid.uri((Dpid)dpid))).build();
        }
        return MeterFeaturesBuilder.noMeterFeatures(DeviceId.deviceId((URI)Dpid.uri((Dpid)dpid)));
    }

    private void pushMeterFeatures(Dpid dpid, OFMeterFeatures meterFeatures) {
        this.providerService.pushMeterFeatures(DeviceId.deviceId((URI)Dpid.uri((Dpid)dpid)), this.buildMeterFeatures(dpid, meterFeatures));
    }

    private void destroyMeterFeatures(Dpid dpid) {
        this.providerService.deleteMeterFeatures(DeviceId.deviceId((URI)Dpid.uri((Dpid)dpid)));
    }

    private Map<Long, Meter> collectMeters(DeviceId deviceId, OFMeterConfigStatsReply reply) {
        return Maps.newHashMap();
    }

    private Collection<Meter> buildMeters(DeviceId deviceId, List<OFMeterStats> entries) {
        return entries.stream().map(stat -> {
            DefaultMeter.Builder builder = DefaultMeter.builder();
            Collection<Band> bands = this.buildBands(stat.getBandStats());
            builder.forDevice(deviceId).withId(MeterId.meterId((long)stat.getMeterId())).fromApp(this.coreService.getAppId("org.onosproject.core")).withBands(bands);
            DefaultMeter meter = builder.build();
            meter.setState(MeterState.ADDED);
            meter.setLife(stat.getDurationSec());
            meter.setProcessedBytes(stat.getByteInCount().getValue());
            meter.setProcessedPackets(stat.getPacketInCount().getValue());
            meter.setReferenceCount(stat.getFlowCount());
            this.pendingOperations.invalidate((Object)stat.getMeterId());
            return meter;
        }).collect(Collectors.toSet());
    }

    private Collection<Band> buildBands(List<OFMeterBandStats> bandStats) {
        return bandStats.stream().map(stat -> {
            DefaultBand band = DefaultBand.builder().build();
            band.setBytes(stat.getByteBandCount().getValue());
            band.setPackets(stat.getPacketBandCount().getValue());
            return band;
        }).collect(Collectors.toSet());
    }

    private void signalMeterError(OFMeterModFailedErrorMsg meterError, MeterOperation op) {
        switch (meterError.getCode()) {
            case UNKNOWN: {
                this.providerService.meterOperationFailed(op, MeterFailReason.UNKNOWN_DEVICE);
                break;
            }
            case METER_EXISTS: {
                this.providerService.meterOperationFailed(op, MeterFailReason.EXISTING_METER);
                break;
            }
            case INVALID_METER: {
                this.providerService.meterOperationFailed(op, MeterFailReason.INVALID_METER);
                break;
            }
            case UNKNOWN_METER: {
                this.providerService.meterOperationFailed(op, MeterFailReason.UNKNOWN);
                break;
            }
            case BAD_COMMAND: {
                this.providerService.meterOperationFailed(op, MeterFailReason.UNKNOWN_COMMAND);
                break;
            }
            case BAD_FLAGS: {
                this.providerService.meterOperationFailed(op, MeterFailReason.UNKNOWN_FLAGS);
                break;
            }
            case BAD_RATE: {
                this.providerService.meterOperationFailed(op, MeterFailReason.BAD_RATE);
                break;
            }
            case BAD_BURST: {
                this.providerService.meterOperationFailed(op, MeterFailReason.BAD_BURST);
                break;
            }
            case BAD_BAND: {
                this.providerService.meterOperationFailed(op, MeterFailReason.BAD_BAND);
                break;
            }
            case BAD_BAND_VALUE: {
                this.providerService.meterOperationFailed(op, MeterFailReason.BAD_BAND_VALUE);
                break;
            }
            case OUT_OF_METERS: {
                this.providerService.meterOperationFailed(op, MeterFailReason.OUT_OF_METERS);
                break;
            }
            case OUT_OF_BANDS: {
                this.providerService.meterOperationFailed(op, MeterFailReason.OUT_OF_BANDS);
                break;
            }
            default: {
                this.providerService.meterOperationFailed(op, MeterFailReason.UNKNOWN);
            }
        }
    }

    protected void bindController(OpenFlowController openFlowController) {
        this.controller = openFlowController;
    }

    protected void unbindController(OpenFlowController openFlowController) {
        if (this.controller == openFlowController) {
            this.controller = null;
        }
    }

    protected void bindProviderRegistry(MeterProviderRegistry meterProviderRegistry) {
        this.providerRegistry = meterProviderRegistry;
    }

    protected void unbindProviderRegistry(MeterProviderRegistry meterProviderRegistry) {
        if (this.providerRegistry == meterProviderRegistry) {
            this.providerRegistry = null;
        }
    }

    protected void bindCoreService(CoreService coreService) {
        this.coreService = coreService;
    }

    protected void unbindCoreService(CoreService coreService) {
        if (this.coreService == coreService) {
            this.coreService = null;
        }
    }

    private class InternalMeterListener
    implements OpenFlowSwitchListener,
    OpenFlowEventListener {
        private InternalMeterListener() {
        }

        public void handleMessage(Dpid dpid, OFMessage msg) {
            switch (msg.getType()) {
                case STATS_REPLY: {
                    OpenFlowMeterProvider.this.pushMeterStats(dpid, (OFStatsReply)msg);
                    break;
                }
                case ERROR: {
                    OFErrorMsg error = (OFErrorMsg)msg;
                    if (error.getErrType() != OFErrorType.METER_MOD_FAILED) break;
                    MeterOperation op = (MeterOperation)OpenFlowMeterProvider.this.pendingOperations.getIfPresent((Object)error.getXid());
                    OpenFlowMeterProvider.this.pendingOperations.invalidate((Object)error.getXid());
                    if (op == null) {
                        OpenFlowMeterProvider.this.log.warn("Unknown Meter operation failed {}", (Object)error);
                        break;
                    }
                    OFMeterModFailedErrorMsg meterError = (OFMeterModFailedErrorMsg)error;
                    OpenFlowMeterProvider.this.signalMeterError(meterError, op);
                    break;
                }
            }
        }

        public void switchAdded(Dpid dpid) {
            OpenFlowMeterProvider.this.createStatsCollection(OpenFlowMeterProvider.this.controller.getSwitch(dpid));
            OpenFlowMeterProvider.this.pushMeterFeatures(dpid, OpenFlowMeterProvider.this.controller.getSwitch(dpid).getMeterFeatures());
        }

        public void switchRemoved(Dpid dpid) {
            OpenFlowMeterProvider.this.stopCollectorIfNeeded((MeterStatsCollector)OpenFlowMeterProvider.this.collectors.remove(dpid));
            OpenFlowMeterProvider.this.destroyMeterFeatures(dpid);
        }

        public void switchChanged(Dpid dpid) {
        }

        public void portChanged(Dpid dpid, OFPortStatus status) {
        }

        public void receivedRoleReply(Dpid dpid, RoleState requested, RoleState response) {
        }
    }
}

