/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.openstacknetworking.web;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.SerializationFeature;
import java.io.InputStream;
import java.net.URI;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriBuilder;
import javax.ws.rs.core.UriInfo;
import org.onlab.osgi.DefaultServiceDirectory;
import org.onosproject.openstacknetworking.api.OpenstackNetworkAdminService;
import org.onosproject.rest.AbstractWebResource;
import org.openstack4j.core.transport.ObjectMapperSingleton;
import org.openstack4j.model.network.Subnet;
import org.openstack4j.openstack.networking.domain.NeutronSubnet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="subnets")
public class OpenstackSubnetWebResource
extends AbstractWebResource {
    protected final Logger log = LoggerFactory.getLogger(this.getClass());
    private static final String MESSAGE = "Received subnets %s request";
    private static final String SUBNETS = "subnets";
    private final OpenstackNetworkAdminService adminService = (OpenstackNetworkAdminService)DefaultServiceDirectory.getService(OpenstackNetworkAdminService.class);
    @Context
    private UriInfo uriInfo;

    @POST
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response createSubnet(InputStream input) {
        this.log.trace(String.format(MESSAGE, "CREATE"));
        NeutronSubnet subnet = this.readSubnet(input);
        this.adminService.createSubnet((Subnet)subnet);
        UriBuilder locationBuilder = this.uriInfo.getBaseUriBuilder().path(SUBNETS).path(subnet.getId());
        return Response.created((URI)locationBuilder.build(new Object[0])).build();
    }

    @PUT
    @Path(value="{id}")
    @Produces(value={"application/json"})
    @Consumes(value={"application/json"})
    public Response updateSubnet(@PathParam(value="id") String id, InputStream input) {
        this.log.trace(String.format(MESSAGE, "UPDATE " + id));
        NeutronSubnet subnet = this.readSubnet(input);
        this.adminService.updateSubnet((Subnet)subnet);
        return Response.status((Response.Status)Response.Status.OK).build();
    }

    @DELETE
    @Path(value="{id}")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response deleteSubnet(@PathParam(value="id") String id) {
        this.log.trace(String.format(MESSAGE, "DELETE " + id));
        this.adminService.removeSubnet(id);
        return Response.noContent().build();
    }

    private NeutronSubnet readSubnet(InputStream input) {
        try {
            JsonNode jsonTree = this.mapper().enable(SerializationFeature.INDENT_OUTPUT).readTree(input);
            this.log.trace(this.mapper().writeValueAsString((Object)jsonTree));
            return (NeutronSubnet)ObjectMapperSingleton.getContext(NeutronSubnet.class).readerFor(NeutronSubnet.class).readValue(jsonTree);
        }
        catch (Exception e) {
            throw new IllegalArgumentException();
        }
    }
}

