/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.openstacknetworking.web;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.SerializationFeature;
import java.io.InputStream;
import java.net.URI;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriBuilder;
import javax.ws.rs.core.UriInfo;
import org.onlab.osgi.DefaultServiceDirectory;
import org.onosproject.openstacknetworking.api.OpenstackSecurityGroupAdminService;
import org.onosproject.rest.AbstractWebResource;
import org.openstack4j.core.transport.ObjectMapperSingleton;
import org.openstack4j.model.network.SecurityGroup;
import org.openstack4j.openstack.networking.domain.NeutronSecurityGroup;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="security-groups")
public class OpenstackSecurityGroupWebResource
extends AbstractWebResource {
    protected final Logger log = LoggerFactory.getLogger(this.getClass());
    private static final String MESSAGE = "Received security groups %s request";
    private static final String SECURITY_GROUPS = "security-groups";
    private final OpenstackSecurityGroupAdminService adminService = (OpenstackSecurityGroupAdminService)DefaultServiceDirectory.getService(OpenstackSecurityGroupAdminService.class);
    @Context
    private UriInfo uriInfo;

    @POST
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response createSecurityGroups(InputStream input) {
        this.log.trace(String.format(MESSAGE, "CREATE"));
        NeutronSecurityGroup sg = this.readSecurityGroup(input);
        this.adminService.createSecurityGroup((SecurityGroup)sg);
        UriBuilder locationBuilder = this.uriInfo.getBaseUriBuilder().path(SECURITY_GROUPS).path(sg.getId());
        return Response.created((URI)locationBuilder.build(new Object[0])).build();
    }

    @PUT
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response updateSecurityGroups(InputStream input) {
        this.log.trace(String.format(MESSAGE, "UPDATE"));
        NeutronSecurityGroup sg = this.readSecurityGroup(input);
        UriBuilder locationBuilder = this.uriInfo.getBaseUriBuilder().path(SECURITY_GROUPS).path(sg.getId());
        return Response.created((URI)locationBuilder.build(new Object[0])).build();
    }

    @DELETE
    @Path(value="{id}")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response removeSecurityGroup(@PathParam(value="id") String id) {
        this.log.trace(String.format(MESSAGE, "REMOVE " + id));
        this.adminService.removeSecurityGroup(id);
        return Response.noContent().build();
    }

    private NeutronSecurityGroup readSecurityGroup(InputStream input) {
        try {
            JsonNode jsonTree = this.mapper().enable(SerializationFeature.INDENT_OUTPUT).readTree(input);
            this.log.trace(this.mapper().writeValueAsString((Object)jsonTree));
            return (NeutronSecurityGroup)ObjectMapperSingleton.getContext(NeutronSecurityGroup.class).readerFor(NeutronSecurityGroup.class).readValue(jsonTree);
        }
        catch (Exception e) {
            throw new IllegalArgumentException();
        }
    }
}

