/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.openstacknetworking.web;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.SerializationFeature;
import java.io.InputStream;
import java.net.URI;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriBuilder;
import javax.ws.rs.core.UriInfo;
import org.onlab.osgi.DefaultServiceDirectory;
import org.onosproject.openstacknetworking.api.OpenstackSecurityGroupAdminService;
import org.onosproject.rest.AbstractWebResource;
import org.openstack4j.core.transport.ObjectMapperSingleton;
import org.openstack4j.model.network.SecurityGroupRule;
import org.openstack4j.openstack.networking.domain.NeutronSecurityGroupRule;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="security-group-rules")
public class OpenstackSecurityGroupRuleWebResource
extends AbstractWebResource {
    protected final Logger log = LoggerFactory.getLogger(this.getClass());
    private static final String MESSAGE = "Received security group rules %s request";
    private static final String SECURITY_GROUP_RULES = "security-group-rules";
    private final OpenstackSecurityGroupAdminService adminService = (OpenstackSecurityGroupAdminService)DefaultServiceDirectory.getService(OpenstackSecurityGroupAdminService.class);
    @Context
    private UriInfo uriInfo;

    @POST
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response createSecurityGroupRules(InputStream input) {
        this.log.trace(String.format(MESSAGE, "CREATE"));
        NeutronSecurityGroupRule sgRule = this.readSecurityGroupRule(input);
        this.adminService.createSecurityGroupRule((SecurityGroupRule)sgRule);
        UriBuilder locationBuilder = this.uriInfo.getBaseUriBuilder().path(SECURITY_GROUP_RULES).path(sgRule.getId());
        return Response.created((URI)locationBuilder.build(new Object[0])).build();
    }

    @DELETE
    @Path(value="{id}")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response removeSecurityGroupRule(@PathParam(value="id") String id) {
        this.log.trace(String.format(MESSAGE, "REMOVE " + id));
        this.adminService.removeSecurityGroupRule(id);
        return Response.noContent().build();
    }

    private NeutronSecurityGroupRule readSecurityGroupRule(InputStream input) {
        try {
            JsonNode jsonTree = this.mapper().enable(SerializationFeature.INDENT_OUTPUT).readTree(input);
            this.log.trace(this.mapper().writeValueAsString((Object)jsonTree));
            return (NeutronSecurityGroupRule)ObjectMapperSingleton.getContext(NeutronSecurityGroupRule.class).readerFor(NeutronSecurityGroupRule.class).readValue(jsonTree);
        }
        catch (Exception e) {
            throw new IllegalArgumentException();
        }
    }
}

