/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.openstacknetworking.web;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.SerializationFeature;
import java.io.InputStream;
import java.net.URI;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriBuilder;
import javax.ws.rs.core.UriInfo;
import org.onlab.osgi.DefaultServiceDirectory;
import org.onosproject.openstacknetworking.api.OpenstackNetworkAdminService;
import org.onosproject.rest.AbstractWebResource;
import org.openstack4j.core.transport.ObjectMapperSingleton;
import org.openstack4j.model.network.Port;
import org.openstack4j.openstack.networking.domain.NeutronPort;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="ports")
public class OpenstackPortWebResource
extends AbstractWebResource {
    protected final Logger log = LoggerFactory.getLogger(this.getClass());
    private static final String MESSAGE = "Received ports %s request";
    private static final String PORTS = "ports";
    private final OpenstackNetworkAdminService adminService = (OpenstackNetworkAdminService)DefaultServiceDirectory.getService(OpenstackNetworkAdminService.class);
    @Context
    private UriInfo uriInfo;

    @POST
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response createPorts(InputStream input) {
        this.log.trace(String.format(MESSAGE, "CREATE"));
        NeutronPort port = this.readPort(input);
        this.adminService.createPort((Port)port);
        UriBuilder locationBuilder = this.uriInfo.getBaseUriBuilder().path(PORTS).path(port.getId());
        return Response.created((URI)locationBuilder.build(new Object[0])).build();
    }

    @PUT
    @Path(value="{id}")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response updatePort(@PathParam(value="id") String id, InputStream input) {
        this.log.trace(String.format(MESSAGE, "UPDATE " + id));
        NeutronPort port = this.readPort(input);
        this.adminService.updatePort((Port)port);
        return Response.status((Response.Status)Response.Status.OK).build();
    }

    @DELETE
    @Path(value="{id}")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response deletePorts(@PathParam(value="id") String id) {
        this.log.trace(String.format(MESSAGE, "DELETE " + id));
        this.adminService.removePort(id);
        return Response.noContent().build();
    }

    private NeutronPort readPort(InputStream input) {
        try {
            JsonNode jsonTree = this.mapper().enable(SerializationFeature.INDENT_OUTPUT).readTree(input);
            this.log.trace(this.mapper().writeValueAsString((Object)jsonTree));
            return (NeutronPort)ObjectMapperSingleton.getContext(NeutronPort.class).readerFor(NeutronPort.class).readValue(jsonTree);
        }
        catch (Exception e) {
            throw new IllegalArgumentException();
        }
    }
}

