/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.openstacknetworking.web;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.SerializationFeature;
import java.io.InputStream;
import java.net.URI;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriBuilder;
import javax.ws.rs.core.UriInfo;
import org.onlab.osgi.DefaultServiceDirectory;
import org.onosproject.openstacknetworking.api.OpenstackRouterAdminService;
import org.onosproject.rest.AbstractWebResource;
import org.openstack4j.core.transport.ObjectMapperSingleton;
import org.openstack4j.model.network.NetFloatingIP;
import org.openstack4j.openstack.networking.domain.NeutronFloatingIP;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="floatingips")
public class OpenstackFloatingIpWebResource
extends AbstractWebResource {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private static final String MESSAGE = "Received floating IP %s request";
    private static final String FLOATING_IPS = "floatingips";
    private final OpenstackRouterAdminService adminService = (OpenstackRouterAdminService)DefaultServiceDirectory.getService(OpenstackRouterAdminService.class);
    @Context
    private UriInfo uriInfo;

    @POST
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response createFloatingIp(InputStream input) {
        this.log.trace(String.format(MESSAGE, "CREATE"));
        NeutronFloatingIP floatingIp = this.readFloatingIp(input);
        this.adminService.createFloatingIp((NetFloatingIP)floatingIp);
        UriBuilder locationBuilder = this.uriInfo.getBaseUriBuilder().path(FLOATING_IPS).path(floatingIp.getId());
        return Response.created((URI)locationBuilder.build(new Object[0])).build();
    }

    @PUT
    @Path(value="{id}")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response updateFloatingIp(@PathParam(value="id") String id, InputStream input) {
        this.log.trace(String.format(MESSAGE, "UPDATE " + id));
        NeutronFloatingIP floatingIp = this.readFloatingIp(input);
        this.adminService.updateFloatingIp((NetFloatingIP)floatingIp);
        return Response.status((Response.Status)Response.Status.OK).build();
    }

    @DELETE
    @Path(value="{id}")
    @Consumes(value={"application/json"})
    public Response deleteFloatingIp(@PathParam(value="id") String id) {
        this.log.trace(String.format(MESSAGE, "DELETE " + id));
        this.adminService.removeFloatingIp(id);
        return Response.noContent().build();
    }

    private NeutronFloatingIP readFloatingIp(InputStream input) {
        try {
            JsonNode jsonTree = this.mapper().enable(SerializationFeature.INDENT_OUTPUT).readTree(input);
            this.log.trace(this.mapper().writeValueAsString((Object)jsonTree));
            return (NeutronFloatingIP)ObjectMapperSingleton.getContext(NeutronFloatingIP.class).readerFor(NeutronFloatingIP.class).readValue(jsonTree);
        }
        catch (Exception e) {
            throw new IllegalArgumentException();
        }
    }
}

