/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.openstacknetworking.web;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.SerializationFeature;
import java.io.InputStream;
import java.net.URI;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriBuilder;
import javax.ws.rs.core.UriInfo;
import org.onlab.osgi.DefaultServiceDirectory;
import org.onosproject.openstacknetworking.api.OpenstackRouterAdminService;
import org.onosproject.rest.AbstractWebResource;
import org.openstack4j.core.transport.ObjectMapperSingleton;
import org.openstack4j.model.network.Router;
import org.openstack4j.model.network.RouterInterface;
import org.openstack4j.openstack.networking.domain.NeutronRouter;
import org.openstack4j.openstack.networking.domain.NeutronRouterInterface;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="routers")
public class OpensatckRouterWebResource
extends AbstractWebResource {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private static final String MESSAGE_ROUTER = "Received router %s request";
    private static final String MESSAGE_ROUTER_IFACE = "Received router interface %s request";
    private static final String ROUTERS = "routers";
    private final OpenstackRouterAdminService adminService = (OpenstackRouterAdminService)DefaultServiceDirectory.getService(OpenstackRouterAdminService.class);
    @Context
    private UriInfo uriInfo;

    @POST
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response createRouter(InputStream input) {
        this.log.trace(String.format(MESSAGE_ROUTER, "CREATE"));
        NeutronRouter osRouter = this.readRouter(input);
        this.adminService.createRouter((Router)osRouter);
        UriBuilder locationBuilder = this.uriInfo.getBaseUriBuilder().path(ROUTERS).path(osRouter.getId());
        return Response.created((URI)locationBuilder.build(new Object[0])).build();
    }

    @PUT
    @Path(value="{id}")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response updateRouter(@PathParam(value="id") String id, InputStream input) {
        this.log.trace(String.format(MESSAGE_ROUTER, "UPDATE " + id));
        NeutronRouter osRouter = this.readRouter(input);
        osRouter.setId(id);
        this.adminService.updateRouter((Router)osRouter);
        return Response.status((Response.Status)Response.Status.OK).build();
    }

    @PUT
    @Path(value="{id}/add_router_interface")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response addRouterInterface(@PathParam(value="id") String id, InputStream input) {
        this.log.trace(String.format(MESSAGE_ROUTER_IFACE, "UPDATE " + id));
        NeutronRouterInterface osRouterIface = this.readRouterInterface(input);
        this.adminService.addRouterInterface((RouterInterface)osRouterIface);
        return Response.status((Response.Status)Response.Status.OK).build();
    }

    @PUT
    @Path(value="{id}/remove_router_interface")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response removeRouterInterface(@PathParam(value="id") String id, InputStream input) {
        this.log.trace(String.format(MESSAGE_ROUTER_IFACE, "DELETE " + id));
        NeutronRouterInterface osRouterIface = this.readRouterInterface(input);
        this.adminService.removeRouterInterface(osRouterIface.getPortId());
        return Response.status((Response.Status)Response.Status.OK).build();
    }

    @DELETE
    @Path(value="{id}")
    @Consumes(value={"application/json"})
    public Response deleteRouter(@PathParam(value="id") String id) {
        this.log.trace(String.format(MESSAGE_ROUTER, "DELETE " + id));
        this.adminService.removeRouter(id);
        return Response.noContent().build();
    }

    private NeutronRouter readRouter(InputStream input) {
        try {
            JsonNode jsonTree = this.mapper().enable(SerializationFeature.INDENT_OUTPUT).readTree(input);
            this.log.trace(this.mapper().writeValueAsString((Object)jsonTree));
            return (NeutronRouter)ObjectMapperSingleton.getContext(NeutronRouter.class).readerFor(NeutronRouter.class).readValue(jsonTree);
        }
        catch (Exception e) {
            throw new IllegalArgumentException();
        }
    }

    private NeutronRouterInterface readRouterInterface(InputStream input) {
        try {
            JsonNode jsonTree = this.mapper().enable(SerializationFeature.INDENT_OUTPUT).readTree(input);
            this.log.trace(this.mapper().writeValueAsString((Object)jsonTree));
            return (NeutronRouterInterface)ObjectMapperSingleton.getContext(NeutronRouterInterface.class).readerFor(NeutronRouterInterface.class).readValue(jsonTree);
        }
        catch (Exception e) {
            throw new IllegalArgumentException();
        }
    }
}

