/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.openstacknetworking.impl;

import org.onlab.packet.Ip4Address;
import org.onosproject.core.ApplicationId;
import org.onosproject.net.Device;
import org.onosproject.net.DeviceId;
import org.onosproject.net.behaviour.ExtensionTreatmentResolver;
import org.onosproject.net.device.DeviceService;
import org.onosproject.net.flow.TrafficSelector;
import org.onosproject.net.flow.TrafficTreatment;
import org.onosproject.net.flow.instructions.ExtensionPropertyException;
import org.onosproject.net.flow.instructions.ExtensionTreatment;
import org.onosproject.net.flow.instructions.ExtensionTreatmentType;
import org.onosproject.net.flowobjective.DefaultForwardingObjective;
import org.onosproject.net.flowobjective.FlowObjectiveService;
import org.onosproject.net.flowobjective.ForwardingObjective;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class RulePopulatorUtil {
    protected static final Logger log = LoggerFactory.getLogger(RulePopulatorUtil.class);
    private static final String TUNNEL_DST = "tunnelDst";

    private RulePopulatorUtil() {
    }

    public static ExtensionTreatment buildExtension(DeviceService deviceService, DeviceId deviceId, Ip4Address remoteIp) {
        Device device = deviceService.getDevice(deviceId);
        if (device == null) {
            return null;
        }
        if (!device.is(ExtensionTreatmentResolver.class)) {
            log.error("The extension treatment is not supported");
            return null;
        }
        ExtensionTreatmentResolver resolver = (ExtensionTreatmentResolver)device.as(ExtensionTreatmentResolver.class);
        ExtensionTreatment treatment = resolver.getExtensionInstruction(ExtensionTreatmentType.ExtensionTreatmentTypes.NICIRA_SET_TUNNEL_DST.type());
        try {
            treatment.setPropertyValue(TUNNEL_DST, (Object)remoteIp);
            return treatment;
        }
        catch (ExtensionPropertyException e) {
            log.warn("Failed to get tunnelDst extension treatment for {}", (Object)deviceId);
            return null;
        }
    }

    public static void setRule(FlowObjectiveService flowObjectiveService, ApplicationId appId, DeviceId deviceId, TrafficSelector selector, TrafficTreatment treatment, ForwardingObjective.Flag flag, int priority, boolean install) {
        DefaultForwardingObjective.Builder foBuilder = DefaultForwardingObjective.builder().withSelector(selector).withTreatment(treatment).withFlag(flag).withPriority(priority).fromApp(appId);
        if (install) {
            flowObjectiveService.forward(deviceId, foBuilder.add());
        } else {
            flowObjectiveService.forward(deviceId, foBuilder.remove());
        }
    }
}

