/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.openstacknetworking.impl;

import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.stream.Collectors;
import org.apache.felix.scr.annotations.Activate;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Deactivate;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.ReferenceCardinality;
import org.apache.felix.scr.annotations.Service;
import org.onlab.packet.IpAddress;
import org.onlab.packet.MacAddress;
import org.onlab.packet.VlanId;
import org.onlab.util.Tools;
import org.onosproject.core.CoreService;
import org.onosproject.event.EventListener;
import org.onosproject.mastership.MastershipService;
import org.onosproject.net.ConnectPoint;
import org.onosproject.net.DefaultAnnotations;
import org.onosproject.net.Host;
import org.onosproject.net.HostId;
import org.onosproject.net.HostLocation;
import org.onosproject.net.Port;
import org.onosproject.net.SparseAnnotations;
import org.onosproject.net.device.DeviceService;
import org.onosproject.net.host.DefaultHostDescription;
import org.onosproject.net.host.HostDescription;
import org.onosproject.net.host.HostProvider;
import org.onosproject.net.host.HostProviderRegistry;
import org.onosproject.net.host.HostProviderService;
import org.onosproject.net.host.HostService;
import org.onosproject.net.provider.AbstractProvider;
import org.onosproject.net.provider.Provider;
import org.onosproject.net.provider.ProviderId;
import org.onosproject.openstacknetworking.api.OpenstackNetworkService;
import org.onosproject.openstacknetworking.impl.OpenstackSwitchingHostProvider;
import org.onosproject.openstacknode.OpenstackNodeService;
import org.openstack4j.model.network.Network;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Service
@Component(immediate=true)
public final class OpenstackSwitchingHostProvider
extends AbstractProvider
implements HostProvider {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private static final String PORT_NAME_PREFIX_VM = "tap";
    private static final String ERR_ADD_HOST = "Failed to add host: ";
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected CoreService coreService;
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected DeviceService deviceService;
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected HostProviderRegistry hostProviderRegistry;
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected HostService hostService;
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected MastershipService mastershipService;
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected OpenstackNetworkService osNetworkService;
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected OpenstackNodeService osNodeService;
    private final ExecutorService deviceEventExecutor = Executors.newSingleThreadExecutor(Tools.groupedThreads((String)"openstacknetworking", (String)"device-event"));
    private final ExecutorService configEventExecutor = Executors.newSingleThreadExecutor(Tools.groupedThreads((String)"openstacknetworking", (String)"config-event"));
    private final InternalDeviceListener internalDeviceListener = new InternalDeviceListener(this, null);
    private final InternalOpenstackNodeListener internalNodeListener = new InternalOpenstackNodeListener(this, null);
    private HostProviderService hostProvider;

    public OpenstackSwitchingHostProvider() {
        super(new ProviderId("host", "org.onosproject.openstacknetworking"));
    }

    @Activate
    protected void activate() {
        this.coreService.registerApplication("org.onosproject.openstacknetworking");
        this.deviceService.addListener((EventListener)this.internalDeviceListener);
        this.osNodeService.addListener((EventListener)this.internalNodeListener);
        this.hostProvider = (HostProviderService)this.hostProviderRegistry.register((Provider)this);
        this.log.info("Started");
    }

    @Deactivate
    protected void deactivate() {
        this.hostProviderRegistry.unregister((Provider)this);
        this.osNodeService.removeListener((EventListener)this.internalNodeListener);
        this.deviceService.removeListener((EventListener)this.internalDeviceListener);
        this.deviceEventExecutor.shutdown();
        this.configEventExecutor.shutdown();
        this.log.info("Stopped");
    }

    public void triggerProbe(Host host) {
    }

    private void processPortAdded(Port port) {
        org.openstack4j.model.network.Port osPort = this.osNetworkService.port(port);
        if (osPort == null) {
            this.log.warn("Failed to add host: OpenStack port for {} not found", (Object)port);
            return;
        }
        Network osNet = this.osNetworkService.network(osPort.getNetworkId());
        if (osNet == null) {
            this.log.warn("Failed to add host: OpenStack network {} not found", (Object)osPort.getNetworkId());
            return;
        }
        if (osPort.getFixedIps().isEmpty()) {
            this.log.warn("Failed to add host: no fixed IP for port {}", (Object)osPort.getId());
            return;
        }
        MacAddress macAddr = MacAddress.valueOf((String)osPort.getMacAddress());
        Set fixedIps = osPort.getFixedIps().stream().map(ip -> IpAddress.valueOf((String)ip.getIpAddress())).collect(Collectors.toSet());
        ConnectPoint connectPoint = new ConnectPoint(port.element().id(), port.number());
        DefaultAnnotations.Builder annotations = DefaultAnnotations.builder().set("networkId", osPort.getNetworkId()).set("portId", osPort.getId()).set("createTime", String.valueOf(System.currentTimeMillis()));
        DefaultHostDescription hostDesc = new DefaultHostDescription(macAddr, VlanId.NONE, new HostLocation(connectPoint, System.currentTimeMillis()), fixedIps, new SparseAnnotations[]{annotations.build()});
        HostId hostId = HostId.hostId((MacAddress)macAddr);
        this.hostProvider.hostDetected(hostId, (HostDescription)hostDesc, false);
    }

    private void processPortRemoved(Port port) {
        ConnectPoint connectPoint = new ConnectPoint(port.element().id(), port.number());
        this.hostService.getConnectedHosts(connectPoint).forEach(host -> this.hostProvider.hostVanished(host.id()));
    }

    static /* synthetic */ ExecutorService access$200(OpenstackSwitchingHostProvider x0) {
        return x0.deviceEventExecutor;
    }

    static /* synthetic */ Logger access$300(OpenstackSwitchingHostProvider x0) {
        return x0.log;
    }

    static /* synthetic */ void access$400(OpenstackSwitchingHostProvider x0, Port x1) {
        x0.processPortRemoved(x1);
    }

    static /* synthetic */ void access$500(OpenstackSwitchingHostProvider x0, Port x1) {
        x0.processPortAdded(x1);
    }

    static /* synthetic */ HostProviderService access$600(OpenstackSwitchingHostProvider x0) {
        return x0.hostProvider;
    }

    protected void bindCoreService(CoreService coreService) {
        this.coreService = coreService;
    }

    protected void unbindCoreService(CoreService coreService) {
        if (this.coreService == coreService) {
            this.coreService = null;
        }
    }

    protected void bindDeviceService(DeviceService deviceService) {
        this.deviceService = deviceService;
    }

    protected void unbindDeviceService(DeviceService deviceService) {
        if (this.deviceService == deviceService) {
            this.deviceService = null;
        }
    }

    protected void bindHostProviderRegistry(HostProviderRegistry hostProviderRegistry) {
        this.hostProviderRegistry = hostProviderRegistry;
    }

    protected void unbindHostProviderRegistry(HostProviderRegistry hostProviderRegistry) {
        if (this.hostProviderRegistry == hostProviderRegistry) {
            this.hostProviderRegistry = null;
        }
    }

    protected void bindHostService(HostService hostService) {
        this.hostService = hostService;
    }

    protected void unbindHostService(HostService hostService) {
        if (this.hostService == hostService) {
            this.hostService = null;
        }
    }

    protected void bindMastershipService(MastershipService mastershipService) {
        this.mastershipService = mastershipService;
    }

    protected void unbindMastershipService(MastershipService mastershipService) {
        if (this.mastershipService == mastershipService) {
            this.mastershipService = null;
        }
    }

    protected void bindOsNetworkService(OpenstackNetworkService openstackNetworkService) {
        this.osNetworkService = openstackNetworkService;
    }

    protected void unbindOsNetworkService(OpenstackNetworkService openstackNetworkService) {
        if (this.osNetworkService == openstackNetworkService) {
            this.osNetworkService = null;
        }
    }

    protected void bindOsNodeService(OpenstackNodeService openstackNodeService) {
        this.osNodeService = openstackNodeService;
    }

    protected void unbindOsNodeService(OpenstackNodeService openstackNodeService) {
        if (this.osNodeService == openstackNodeService) {
            this.osNodeService = null;
        }
    }
}

